/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.api;

import java.util.Collection;
import java.util.HashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mule.metadata.ast.api.Property;

public final class TypeUtils {
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private TypeUtils() {
    }

    public static Collection<Property> getProperties(Element element, ProcessingEnvironment processingEnvironment) {
        HashMap properties = new HashMap();
        element.getEnclosedElements().stream().filter(elem -> elem.getKind().equals((Object)ElementKind.METHOD)).map(elem -> (ExecutableElement)elem).forEach(elem -> {
            String methodName = elem.getSimpleName().toString();
            if (methodName.startsWith(GET_PREFIX)) {
                String propertyName = methodName.substring(3);
                TypeUtils.addGetter(properties, elem, propertyName);
            } else if (methodName.startsWith(IS_PREFIX) && TypeUtils.isBooleanType(elem.getReturnType(), processingEnvironment)) {
                String propertyName = methodName.substring(2);
                TypeUtils.addGetter(properties, elem, propertyName);
            } else if (methodName.startsWith(SET_PREFIX)) {
                String propertyName = methodName.substring(3);
                TypeUtils.addSetter(properties, elem, propertyName);
            }
        });
        return properties.values();
    }

    private static void addSetter(HashMap<String, Property> properties, ExecutableElement elem, String propertyName) {
        Property property = properties.get(propertyName);
        if (property == null) {
            property = new Property();
            property.setSetterMethod(elem);
            property.setName(propertyName);
            properties.put(propertyName, property);
        } else {
            property.setSetterMethod(elem);
        }
    }

    private static void addGetter(HashMap<String, Property> properties, ExecutableElement elem, String propertyName) {
        Property property = properties.get(propertyName);
        if (property == null) {
            property = new Property();
            property.setGetterMethod(elem);
            property.setName(propertyName);
            properties.put(propertyName, property);
        } else {
            property.setGetterMethod(elem);
        }
    }

    private static boolean isBooleanType(TypeMirror typeMirror, ProcessingEnvironment processingEnvironment) {
        if (typeMirror instanceof PrimitiveType && typeMirror.getKind().equals((Object)TypeKind.BOOLEAN)) {
            return true;
        }
        if (typeMirror instanceof DeclaredType) {
            return processingEnvironment.getTypeUtils().isSameType(typeMirror, processingEnvironment.getElementUtils().getTypeElement(Boolean.class.getName()).asType());
        }
        return false;
    }
}

