/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

public class ClassInformationAnnotationFactory {
    private static final List<String> arrayInterfaces = Arrays.stream(String[].class.getInterfaces()).map(Class::getCanonicalName).collect(Collectors.toList());
    private static Map<String, Class> primitiveTypeClasses = new HashMap<String, Class>(){
        {
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("double", Double.TYPE);
            this.put("float", Float.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("char", Character.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("void", Void.TYPE);
            this.put("short", Short.TYPE);
        }
    };

    public static ClassInformationAnnotation fromTypeMirror(TypeMirror typeMirror, ProcessingEnvironment processingEnvironment) {
        if (typeMirror instanceof ArrayType) {
            return ClassInformationAnnotationFactory.fromArrayType((ArrayType)typeMirror);
        }
        if (typeMirror instanceof PrimitiveType) {
            return ClassInformationAnnotationFactory.fromPrimitiveType((PrimitiveType)typeMirror);
        }
        if (typeMirror instanceof DeclaredType) {
            return ClassInformationAnnotationFactory.fromDeclaredType((DeclaredType)typeMirror, processingEnvironment);
        }
        throw new IllegalArgumentException("The given TypeMirror is not supported. Type: " + typeMirror.getClass());
    }

    private static ClassInformationAnnotation fromPrimitiveType(PrimitiveType typeMirror) {
        return new ClassInformationAnnotation(primitiveTypeClasses.get(typeMirror.toString()));
    }

    private static ClassInformationAnnotation fromArrayType(ArrayType arrayType) {
        String classname = arrayType.toString().replace(".NestedClassType", "$NestedClassType");
        return new ClassInformationAnnotation(classname, false, false, false, true, true, Collections.unmodifiableList(arrayInterfaces), "", Collections.emptyList(), false);
    }

    private static ClassInformationAnnotation fromDeclaredType(DeclaredType declaredType, ProcessingEnvironment processingEnvironment) {
        String classname;
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String name = typeElement.getQualifiedName().toString();
        try {
            classname = Class.forName(name).getName();
        }
        catch (ClassNotFoundException e) {
            classname = name.replace(".NestedClassType", "$NestedClassType");
        }
        List<String> implementedInterfaces = ClassInformationAnnotationFactory.getImplementedInterfaces(processingEnvironment, typeElement);
        String parent = ClassInformationAnnotationFactory.getParentClass(processingEnvironment, typeElement);
        boolean isFinal = typeElement.getModifiers().contains((Object)Modifier.FINAL);
        boolean isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean isInterface = typeElement.getKind().isInterface();
        boolean hasDefaultConstructor = ClassInformationAnnotationFactory.hasDefaultConstructor(typeElement, isInterface);
        List<String> genericTypes = ClassInformationAnnotationFactory.getGenericTypes(declaredType, processingEnvironment);
        boolean isInstantiable = !isInterface && !isAbstract && hasDefaultConstructor;
        boolean isMap = ClassInformationAnnotationFactory.isMap(processingEnvironment, typeElement);
        return new ClassInformationAnnotation(classname, hasDefaultConstructor, isInterface, isInstantiable, isAbstract, isFinal, implementedInterfaces, parent, genericTypes, isMap);
    }

    private static List<String> getImplementedInterfaces(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        return typeElement.getInterfaces().stream().map(inter -> processingEnvironment.getTypeUtils().asElement((TypeMirror)inter)).map(element -> processingEnvironment.getElementUtils().getBinaryName((TypeElement)element)).map(CharSequence::toString).collect(Collectors.toList());
    }

    private static String getParentClass(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (!superclass.getKind().equals((Object)TypeKind.NONE) && !processingEnvironment.getTypeUtils().isSameType(processingEnvironment.getElementUtils().getTypeElement(Object.class.getName()).asType(), superclass)) {
            return processingEnvironment.getElementUtils().getBinaryName((TypeElement)processingEnvironment.getTypeUtils().asElement(superclass)).toString();
        }
        return "";
    }

    private static List<String> getGenericTypes(DeclaredType declaredType, ProcessingEnvironment processingEnvironment) {
        return declaredType.getTypeArguments().stream().map(typeMirror -> processingEnvironment.getTypeUtils().asElement((TypeMirror)typeMirror)).filter(elem -> elem instanceof TypeElement).map(elem -> processingEnvironment.getElementUtils().getBinaryName((TypeElement)elem)).map(CharSequence::toString).collect(Collectors.toList());
    }

    private static boolean isMap(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        return processingEnvironment.getTypeUtils().isAssignable(processingEnvironment.getTypeUtils().erasure(typeElement.asType()), processingEnvironment.getElementUtils().getTypeElement(Map.class.getName()).asType());
    }

    private static boolean hasDefaultConstructor(TypeElement typeElement, boolean isInterface) {
        List constructors = typeElement.getEnclosedElements().stream().filter(elem -> elem.getKind().equals((Object)ElementKind.CONSTRUCTOR)).map(elem -> (ExecutableElement)elem).collect(Collectors.toList());
        boolean containsDefaultConstructor = constructors.stream().filter(elem -> elem.getModifiers().contains((Object)Modifier.PUBLIC)).anyMatch(executableElement -> executableElement.getParameters().size() == 0);
        return !isInterface && (constructors.isEmpty() || containsDefaultConstructor && typeElement.getModifiers().contains((Object)Modifier.PUBLIC));
    }
}

