/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.internal.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.DefaultTypeResolver;
import org.mule.metadata.catalog.internal.builder.TypeLoaderRegistry;
import org.mule.metadata.catalog.internal.builder.TypesResolverBuilder;
import org.mule.metadata.catalog.internal.model.loaders.example.JsonTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.example.XmlTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.CsvTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.JavaTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.JsonRamlTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.JsonSchemaTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.MapTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.XmlRamlTypeLoaderFactory;
import org.mule.metadata.catalog.internal.model.loaders.shape.XmlSchemaTypeLoaderFactory;

public class TypesCatalogBuilder {
    private final TypeLoaderRegistry shapesRegistry;
    private final TypeLoaderRegistry examplesRegistry;
    private final List<TypesResolverBuilder> typesResolverBuilders;
    private URI baseUri;

    public TypesCatalogBuilder(URI baseUri, ClassLoader classLoader) {
        this.baseUri = baseUri;
        this.shapesRegistry = new TypeLoaderRegistry(Arrays.asList(new JsonSchemaTypeLoaderFactory(), new XmlSchemaTypeLoaderFactory(), new JavaTypeLoaderFactory(classLoader), new CsvTypeLoaderFactory(), new MapTypeLoaderFactory(), new JsonRamlTypeLoaderFactory(), new XmlRamlTypeLoaderFactory()));
        this.examplesRegistry = new TypeLoaderRegistry(Arrays.asList(new JsonTypeLoaderFactory(), new XmlTypeLoaderFactory()));
        this.typesResolverBuilders = new ArrayList<TypesResolverBuilder>();
    }

    public void addTypesResolver(Consumer<TypesResolverBuilder> typesResolverBuilderConsumer) {
        TypesResolverBuilder typesResolverBuilder = new TypesResolverBuilder(this.baseUri);
        typesResolverBuilderConsumer.accept(typesResolverBuilder);
        this.typesResolverBuilders.add(typesResolverBuilder);
    }

    public DefaultTypeResolver build() {
        HashMap<String, TypeLoader> loaders = new HashMap<String, TypeLoader>();
        for (TypesResolverBuilder typesResolverBuilder : this.typesResolverBuilders) {
            try {
                loaders.put(typesResolverBuilder.getCatalogName(), typesResolverBuilder.build(this.shapesRegistry, this.examplesRegistry));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to add type declaration '%s' to types catalog. Original error was: %s.", typesResolverBuilder.getCatalogName(), e.getMessage()), e);
            }
        }
        return new DefaultTypeResolver(loaders);
    }
}

