/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;

public class FunctionTypeBuilder
extends AbstractBuilder<FunctionType>
implements TypeBuilder<FunctionType>,
WithAnnotation<FunctionTypeBuilder> {
    private List<FunctionParameterBuilder> parameterBuilders = new ArrayList<FunctionParameterBuilder>();
    private MetadataType returnType;
    private Optional<TypeBuilder<?>> returnTypeBuilder = Optional.empty();

    protected FunctionTypeBuilder(MetadataFormat format) {
        super(format);
    }

    @Override
    public FunctionTypeBuilder with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    public FunctionTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    public FunctionTypeBuilder defaultValue(String defaultValue) {
        return this.with(new DefaultValueAnnotation(defaultValue));
    }

    public BaseTypeBuilder addParameterOf(String name) {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.parameterBuilders.add(new FunctionParameterBuilder(name, typeBuilder));
        return typeBuilder;
    }

    public BaseTypeBuilder addOptionalParameterOf(String name) {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.parameterBuilders.add(new FunctionParameterBuilder(name, typeBuilder, true));
        return typeBuilder;
    }

    public FunctionTypeBuilder addParameterOf(String name, TypeBuilder<?> paramType) {
        this.parameterBuilders.add(new FunctionParameterBuilder(name, paramType));
        return this;
    }

    public FunctionTypeBuilder addOptionalParameterOf(String name, TypeBuilder<?> paramType) {
        this.parameterBuilders.add(new FunctionParameterBuilder(name, paramType, true));
        return this;
    }

    public FunctionTypeBuilder addParameterOf(String name, MetadataType paramType) {
        this.parameterBuilders.add(new FunctionParameterBuilder(name, paramType));
        return this;
    }

    public FunctionTypeBuilder addOptionalParameterOf(String name, MetadataType paramType) {
        this.parameterBuilders.add(new FunctionParameterBuilder(name, paramType, true));
        return this;
    }

    public FunctionTypeBuilder returnType(TypeBuilder<?> returnTypeBuilder) {
        this.returnTypeBuilder = Optional.of(returnTypeBuilder);
        return this;
    }

    public FunctionTypeBuilder returnType(MetadataType returnType) {
        this.returnType = returnType;
        return this;
    }

    public BaseTypeBuilder returnType() {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.returnTypeBuilder = Optional.of(typeBuilder);
        return typeBuilder;
    }

    @Override
    public FunctionType build() {
        Optional<MetadataType> returnTypeOptional = this.returnType != null ? Optional.of(this.returnType) : this.returnTypeBuilder.map(TypeBuilder::build);
        return new DefaultFunctionType(this.format, this.annotations, returnTypeOptional, this.parameterBuilders.stream().map(ptb -> ((FunctionParameterBuilder)ptb).build()).collect(Collectors.toList()));
    }

    private static class FunctionParameterBuilder {
        private String name;
        private MetadataType metadataType;
        private boolean optional;
        private TypeBuilder<?> builder;

        FunctionParameterBuilder(String name, TypeBuilder<?> builder) {
            this(name, builder, false);
        }

        FunctionParameterBuilder(String name, TypeBuilder<?> builder, boolean optional) {
            this.name = name;
            this.builder = builder;
            this.optional = optional;
        }

        FunctionParameterBuilder(String name, MetadataType metadataType) {
            this(name, metadataType, false);
        }

        FunctionParameterBuilder(String name, MetadataType metadataType, boolean optional) {
            this.name = name;
            this.metadataType = metadataType;
            this.optional = optional;
        }

        private FunctionParameter build() {
            MetadataType type = this.metadataType != null ? this.metadataType : this.builder.build();
            return new FunctionParameter(this.name, type, this.optional);
        }
    }
}

