/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class DefaultArrayType
extends BaseMetadataType
implements ArrayType {
    private final Supplier<MetadataType> type;
    private MetadataType typeValue;

    public DefaultArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.type = type;
    }

    @Override
    public MetadataType getType() {
        return this.type.get();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitArrayType(this);
    }

    @Override
    public Object[] getFieldValues() {
        ArrayList fieldValues = new ArrayList();
        Collections.addAll(fieldValues, super.getFieldValues());
        Collections.addAll(fieldValues, this.typeValue);
        return fieldValues.toArray(new Object[fieldValues.size()]);
    }

    private void setTypeValueForReflectionEqualsIfNull() {
        if (Objects.isNull(this.typeValue)) {
            this.typeValue = this.type.get();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        this.setTypeValueForReflectionEqualsIfNull();
        ((DefaultArrayType)obj).setTypeValueForReflectionEqualsIfNull();
        return super.equals(obj);
    }
}

