/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static org.apache.commons.lang3.ArrayUtils.addAll;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.lang.reflect.Field;
import java.util.Map;

public class DefaultAttributeFieldType extends BaseMetadataType implements AttributeFieldType {

  private final AttributeKeyType key;
  private final MetadataType value;
  private final boolean required;

  public DefaultAttributeFieldType(AttributeKeyType key, MetadataType value, boolean required, MetadataFormat metadataFormat,
                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.key = key;
    this.value = value;
    this.required = required;
  }

  private static final Field[] REFLECTION_FIELDS;
  static {
    try {
      REFLECTION_FIELDS = addAll(BASE_REFLECTION_FIELDS,
                                 DefaultAttributeFieldType.class.getDeclaredField("key"),
                                 DefaultAttributeFieldType.class.getDeclaredField("value"),
                                 DefaultAttributeFieldType.class.getDeclaredField("required"));
    } catch (NoSuchFieldException e) {
      throw new RuntimeException("Could not resolve field", e);
    }
  }

  @Override
  public AttributeKeyType getKey() {
    return key;
  }

  @Override
  public MetadataType getValue() {
    return value;
  }

  @Override
  public boolean isRequired() {
    return required;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitAttributeField(this);
  }

  @Override
  public Field[] getReflectionComparableFields() {
    return REFLECTION_FIELDS;
  }
}
