/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;

/**
 * A default value for the annotated type
 */
public class DefaultValueAnnotation implements TypeAnnotation {

  public static final String NAME = "default";
  private final String value;

  public DefaultValueAnnotation(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof DefaultValueAnnotation) {
      return Objects.equals(value, ((DefaultValueAnnotation) obj).getValue());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return value.hashCode();
  }
}
