/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.internal.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.metadata.api.model.ReflectionAwareComparable;
import org.mule.metadata.internal.utils.IDKey;

public class EfficientReflectionEquals {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> EQUALS_REGISTRY = new ThreadLocal();

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return EQUALS_REGISTRY.get();
    }

    static Pair<IDKey, IDKey> getRegisterPair(Object lhs, Object rhs) {
        IDKey left = new IDKey(lhs);
        IDKey right = new IDKey(rhs);
        return Pair.of((Object)left, (Object)right);
    }

    static boolean isRegistered(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientReflectionEquals.getRegistry();
        Pair<IDKey, IDKey> pair = EfficientReflectionEquals.getRegisterPair(lhs, rhs);
        Pair swappedPair = Pair.of((Object)pair.getRight(), (Object)pair.getLeft());
        return registry != null && (registry.contains(pair) || registry.contains(swappedPair));
    }

    private static void register(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientReflectionEquals.getRegistry();
        if (registry == null) {
            registry = new HashSet<Pair<IDKey, IDKey>>();
            EQUALS_REGISTRY.set(registry);
        }
        Pair<IDKey, IDKey> pair = EfficientReflectionEquals.getRegisterPair(lhs, rhs);
        registry.add(pair);
    }

    private static void unregister(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientReflectionEquals.getRegistry();
        if (registry != null) {
            Pair<IDKey, IDKey> pair = EfficientReflectionEquals.getRegisterPair(lhs, rhs);
            registry.remove(pair);
            if (registry.isEmpty()) {
                EQUALS_REGISTRY.remove();
            }
        }
    }

    private EfficientReflectionEquals() {
    }

    public static boolean reflectionEquals(ReflectionAwareComparable thisObj, ReflectionAwareComparable thatObj) {
        if (EfficientReflectionEquals.isRegistered(thisObj, thatObj)) {
            return true;
        }
        try {
            EfficientReflectionEquals.register(thisObj, thatObj);
            AccessibleObject[] fields = thisObj.getReflectionComparableFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                Object thatField;
                Object thisField = ((Field)field).get(thisObj);
                if (thisField == (thatField = ((Field)field).get(thatObj))) continue;
                if (thisField == null) {
                    boolean bl = false;
                    return bl;
                }
                if (thisField.equals(thatField)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error running reflective equals", e);
        }
        finally {
            EfficientReflectionEquals.unregister(thisObj, thatObj);
        }
    }
}

