/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.internal.utils.LazyValue;

public class TupleTypeBuilder
extends AbstractBuilder<TupleType>
implements TypeBuilder<TupleType>,
WithAnnotation<TupleTypeBuilder> {
    private final List<TypeBuilder<?>> types = new LinkedList();
    private final LazyValue<TupleType> result = new LazyValue();

    protected TupleTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public BaseTypeBuilder of() {
        BaseTypeBuilder builder = new BaseTypeBuilder(this.format);
        this.types.add(builder);
        return builder;
    }

    public TupleTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    public TupleTypeBuilder of(TypeBuilder<?> typeBuilder) {
        this.types.add(typeBuilder);
        return this;
    }

    public TupleTypeBuilder description(String lang, String content) {
        return this.with(new DescriptionAnnotation(content, lang));
    }

    public TupleTypeBuilder description(String content) {
        return this.with(new DescriptionAnnotation(content));
    }

    public TupleTypeBuilder label(String label) {
        return this.with(new LabelAnnotation(label));
    }

    @Override
    public TupleTypeBuilder with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    @Override
    public TupleType build() {
        if (this.types.isEmpty()) {
            throw new RuntimeException("Tuple needs at least one type");
        }
        ArrayList types = new ArrayList();
        boolean needsInit = !this.result.isDefined();
        TupleType tupleType = this.result.get(() -> new DefaultTupleType(types, this.format, this.annotations));
        if (needsInit) {
            List createdTypes = this.types.stream().map(builder -> builder.build()).collect(Collectors.toList());
            types.addAll(createdTypes);
        }
        return tupleType;
    }
}

