/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.internal.utils.LazyValue;

public class IntersectionTypeBuilder
extends AbstractBuilder<IntersectionType>
implements TypeBuilder<IntersectionType>,
WithAnnotation<IntersectionTypeBuilder> {
    private List<TypeBuilder<?>> types = new LinkedList();
    private final LazyValue<IntersectionType> result = new LazyValue();

    protected IntersectionTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public BaseTypeBuilder of() {
        BaseTypeBuilder builder = new BaseTypeBuilder(this.format);
        this.types.add(builder);
        return builder;
    }

    public IntersectionTypeBuilder of(TypeBuilder<?> of) {
        this.types.add(of);
        return this;
    }

    public IntersectionTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    @Override
    public IntersectionTypeBuilder with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    @Override
    public IntersectionType build() {
        if (this.types.isEmpty()) {
            throw new RuntimeException("IntersectionType needs at least one type");
        }
        ArrayList types = new ArrayList();
        boolean needsInit = !this.result.isDefined();
        IntersectionType intersectionType = this.result.get(() -> new DefaultIntersectionType(types, this.format, this.annotations));
        if (needsInit) {
            List createdTypes = this.types.stream().map(builder -> builder.build()).collect(Collectors.toList());
            types.addAll(createdTypes);
        }
        return intersectionType;
    }
}

