/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.features.internal.generator;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.features.internal.generator.AbstractClassGenerator;

class MuleSystemPropertiesGenerator
extends AbstractClassGenerator {
    private static final String PACKAGE_NAME = "org.mule.runtime.features.api";
    private static final String MULE_SYSTEM_PROPERTIES_CLASS_NAME = "MuleSystemProperties";
    private final List<MuleSystemPropertyDeclaration> originalPropertiesFromMuleApi = MuleSystemPropertiesGenerator.getOriginalPropertiesFromMuleApi();

    public MuleSystemPropertiesGenerator(File outputDir) throws ClassNotFoundException {
        super(outputDir);
    }

    @Override
    protected String getPackageName() {
        return PACKAGE_NAME;
    }

    @Override
    protected Set<String> getImports() {
        return MuleSystemPropertiesGenerator.collectImports(this.originalPropertiesFromMuleApi);
    }

    @Override
    protected String getClassName() {
        return MULE_SYSTEM_PROPERTIES_CLASS_NAME;
    }

    @Override
    protected void writeClassContent(OutputStream outputStream) throws IOException {
        this.appendLine(outputStream, "public class " + this.getClassName() + " {");
        for (MuleSystemPropertyDeclaration property : this.originalPropertiesFromMuleApi) {
            for (Class<? extends Annotation> annotation : property.getAnnotations()) {
                this.appendLine(outputStream, "\t@" + annotation.getSimpleName());
            }
            this.appendLine(outputStream, "\tpublic static final String " + property.getName() + " = \"" + property.getValue() + "\";");
            this.appendLine(outputStream);
        }
        this.appendLine(outputStream, "\tprivate " + this.getClassName() + "() {");
        this.appendLine(outputStream, "\t\t// Private constructor to prevent instantiation");
        this.appendLine(outputStream, "\t}");
        this.appendLine(outputStream);
        this.appendLine(outputStream, "}");
    }

    private static Set<String> collectImports(List<MuleSystemPropertyDeclaration> properties) {
        return properties.stream().flatMap(prop -> prop.getAnnotations().stream()).filter(AbstractClassGenerator::isImportNeeded).map(Class::getName).collect(Collectors.toSet());
    }

    private static List<MuleSystemPropertyDeclaration> getOriginalPropertiesFromMuleApi() throws ClassNotFoundException {
        Class<?> muleApiProperties = Class.forName("org.mule.runtime.api.util.MuleSystemProperties");
        Field[] fields = muleApiProperties.getFields();
        return Arrays.stream(fields).filter(AbstractClassGenerator::isPublicStaticFinalString).map(f -> {
            try {
                List<Class<? extends Annotation>> annotations = Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).filter(AbstractClassGenerator::isAvailableAnnotation).collect(Collectors.toList());
                return new MuleSystemPropertyDeclaration(f.getName(), (String)f.get(null), annotations);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private static class MuleSystemPropertyDeclaration {
        private final String name;
        private final String value;
        private final List<Class<? extends Annotation>> annotations;

        public MuleSystemPropertyDeclaration(String name, String value, List<Class<? extends Annotation>> annotations) {
            this.name = name;
            this.value = value;
            this.annotations = annotations;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public List<Class<? extends Annotation>> getAnnotations() {
            return this.annotations;
        }
    }
}

