/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.features.internal.generator;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.features.internal.generator.AbstractClassGenerator;

class MuleFeaturesGenerator
extends AbstractClassGenerator {
    private static final String PACKAGE_NAME = "org.mule.runtime.features.api";
    private static final String MULE_FEATURE_CLASS_NAME = "MuleRuntimeFeature";
    private static final Class<?> MULE_API_FEATURE_CLASS;
    private final List<MuleFeatureDeclaration> originalPropertiesFromMuleApi = MuleFeaturesGenerator.getOriginalFeatureFromMuleApi();

    public MuleFeaturesGenerator(File outputDir) {
        super(outputDir);
    }

    @Override
    protected String getPackageName() {
        return PACKAGE_NAME;
    }

    @Override
    protected Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        imports.add("org.mule.runtime.api.config.Feature");
        imports.add("java.util.Optional");
        imports.addAll(MuleFeaturesGenerator.collectImports(this.originalPropertiesFromMuleApi));
        return imports;
    }

    @Override
    protected String getClassName() {
        return MULE_FEATURE_CLASS_NAME;
    }

    @Override
    protected void writeClassContent(OutputStream outputStream) throws IOException {
        this.appendLine(outputStream, "public enum " + this.getClassName() + " implements Feature {");
        for (MuleFeatureDeclaration property : this.originalPropertiesFromMuleApi) {
            for (Class<? extends Annotation> annotation : property.getAnnotations()) {
                this.appendLine(outputStream, "\t@" + annotation.getSimpleName());
            }
            String overridingProperty = property.getOverridingSystemPropertyName().orElse(null);
            String minJavaVersion = property.getMinJavaVersion().orElse(null);
            this.appendLine(outputStream, String.format("\t%s(\"%s\", \"%s\", \"%s\", %s, %s),", property.getName(), property.getDescription(), property.getIssueId(), property.getEnabledByDefaultSince(), overridingProperty != null ? "\"" + overridingProperty + "\"" : "null", minJavaVersion != null ? "\"" + minJavaVersion + "\"" : "null"));
            this.appendLine(outputStream);
        }
        this.appendLine(outputStream, "\t;");
        this.appendLine(outputStream, "\tprivate final String description;");
        this.appendLine(outputStream, "\tprivate final String issueId;");
        this.appendLine(outputStream, "\tprivate final String enabledByDefaultSince;");
        this.appendLine(outputStream, "\tprivate final String overridingSystemPropertyName;");
        this.appendLine(outputStream, "\tprivate final String minJavaVersion;");
        this.appendLine(outputStream);
        this.appendLine(outputStream, "\t" + this.getClassName() + "(String description, String issueId, String enabledByDefaultSince, String overridingSystemPropertyName, String minJavaVersion) {");
        this.appendLine(outputStream, "\t\tthis.description = description;");
        this.appendLine(outputStream, "\t\tthis.issueId = issueId;");
        this.appendLine(outputStream, "\t\tthis.enabledByDefaultSince = enabledByDefaultSince;");
        this.appendLine(outputStream, "\t\tthis.overridingSystemPropertyName = overridingSystemPropertyName;");
        this.appendLine(outputStream, "\t\tthis.minJavaVersion = minJavaVersion;");
        this.appendLine(outputStream, "\t}");
        this.appendLine(outputStream);
        this.appendLine(outputStream, "\tpublic String getName() {\treturn name();\t} ");
        this.appendLine(outputStream, "\tpublic String getDescription() {\treturn description;\t} ");
        this.appendLine(outputStream, "\tpublic String getIssueId() {\treturn issueId;\t} ");
        this.appendLine(outputStream, "\tpublic String getSince() {\treturn getEnabledByDefaultSince();\t} ");
        this.appendLine(outputStream, "\tpublic String getEnabledByDefaultSince() {\treturn enabledByDefaultSince;\t} ");
        this.appendLine(outputStream, "\tpublic Optional<String> getOverridingSystemPropertyName() {\treturn Optional.ofNullable(overridingSystemPropertyName);\t}");
        this.appendLine(outputStream, "\tpublic Optional<String> getMinJavaVersion() {\treturn Optional.ofNullable(minJavaVersion);\t}");
        this.appendLine(outputStream, "}");
    }

    private static Set<String> collectImports(List<MuleFeatureDeclaration> properties) {
        return properties.stream().flatMap(prop -> prop.getAnnotations().stream()).filter(AbstractClassGenerator::isImportNeeded).map(Class::getName).collect(Collectors.toSet());
    }

    private static List<MuleFeatureDeclaration> getOriginalFeatureFromMuleApi() {
        Field[] fields = MULE_API_FEATURE_CLASS.getFields();
        return Arrays.stream(fields).filter(field -> AbstractClassGenerator.isPublicStaticFinalFeature(field, MULE_API_FEATURE_CLASS)).map(f -> {
            try {
                List<Class<? extends Annotation>> annotations = Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).filter(AbstractClassGenerator::isAvailableAnnotation).collect(Collectors.toList());
                return new MuleFeatureDeclaration(f.getName(), f.get(null), annotations);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    static {
        try {
            MULE_API_FEATURE_CLASS = Class.forName("org.mule.runtime.api.config.MuleRuntimeFeature");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MuleFeatureDeclaration {
        private final String name;
        private final String description;
        private final String issueId;
        private final String enabledByDefaultSince;
        private final Optional<String> overridingSystemPropertyName;
        private final Optional<String> minJavaVersion;
        private final List<Class<? extends Annotation>> annotations;

        public MuleFeatureDeclaration(String name, Object value, List<Class<? extends Annotation>> annotations) {
            this.name = name;
            this.annotations = annotations;
            Feature feature = (Feature)value;
            String rawDescription = feature.getDescription();
            this.description = rawDescription != null ? rawDescription.replaceAll("\\R", "\\\\n").trim() : name;
            this.issueId = feature.getIssueId();
            this.enabledByDefaultSince = feature.getEnabledByDefaultSince();
            this.overridingSystemPropertyName = feature.getOverridingSystemPropertyName();
            this.minJavaVersion = feature.getMinJavaVersion();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIssueId() {
            return this.issueId;
        }

        public String getEnabledByDefaultSince() {
            return this.enabledByDefaultSince;
        }

        public Optional<String> getMinJavaVersion() {
            return this.minJavaVersion;
        }

        public Optional<String> getOverridingSystemPropertyName() {
            return this.overridingSystemPropertyName;
        }

        public List<Class<? extends Annotation>> getAnnotations() {
            return this.annotations;
        }
    }
}

