/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.features.internal.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

abstract class AbstractClassGenerator {
    private final File outputDir;

    AbstractClassGenerator(File outputDir) {
        this.outputDir = outputDir;
    }

    protected abstract String getPackageName();

    protected abstract Set<String> getImports();

    protected abstract String getClassName();

    protected abstract void writeClassContent(OutputStream var1) throws IOException;

    protected void appendLine(OutputStream outputStream, String line) throws IOException {
        outputStream.write((line + "\n").getBytes());
    }

    protected void appendLine(OutputStream outputStream) throws IOException {
        this.appendLine(outputStream, "");
    }

    public void generate() throws IOException {
        Path packageLocation = Paths.get(this.outputDir.getAbsolutePath(), AbstractClassGenerator.getLocationFromPackageName(this.getPackageName()));
        Files.createDirectories(packageLocation, new FileAttribute[0]);
        File generatedJava = packageLocation.resolve(this.getClassName() + ".java").toFile();
        generatedJava.createNewFile();
        try (FileOutputStream outputStream = new FileOutputStream(generatedJava);){
            this.appendLine(outputStream, "package " + this.getPackageName() + ";");
            this.appendLine(outputStream);
            for (String importedClass : this.getImports()) {
                this.appendLine(outputStream, "import " + importedClass + ";");
            }
            this.writeClassContent(outputStream);
        }
    }

    private static String getLocationFromPackageName(String packageName) {
        return packageName.replace(".", "/");
    }

    protected static boolean isPublicStaticFinalString(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(String.class);
    }

    protected static boolean isPublicStaticFinalFeature(Field field, Class<?> featureClass) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(featureClass);
    }

    protected static boolean isAvailableAnnotation(Class<? extends Annotation> annotation) {
        return !annotation.getPackageName().startsWith("org.mule.api.annotation");
    }

    protected static boolean isImportNeeded(Class<?> cls) {
        return !cls.getPackageName().startsWith("java.lang");
    }
}

