/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.soap.message;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

abstract class BaseDispatchingContext {
    private static final String CONTENT_TYPE = "Content-Type";
    private final InputStream content;
    private final Map<String, String> headers;

    BaseDispatchingContext(InputStream content, Map<String, String> headers) {
        this.content = content;
        this.headers = headers;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.getHeader(CONTENT_TYPE).orElseGet(() -> this.getHeader(CONTENT_TYPE.toLowerCase()).orElseThrow(() -> new IllegalStateException("No Content-Typeboundled in the message")));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<String> getHeader(String headerName) {
        return Optional.ofNullable(this.headers.get(headerName));
    }
}

