/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DslBaseType;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;

public class TypeDslAnnotation
implements TypeAnnotation {
    public static final String NAME = "typeDsl";
    private final boolean allowInlineDefinition;
    private final boolean allowTopLevelDefinition;
    private final SubstitutionGroup substitutionGroup;
    private final DslBaseType dslBaseType;

    public TypeDslAnnotation(boolean allowInlineDefinition, boolean allowTopLevelDefinition, String substitutionGroup, String baseType) {
        this.allowInlineDefinition = allowInlineDefinition;
        this.allowTopLevelDefinition = allowTopLevelDefinition;
        SubstitutionGroup substitutionGroupObject = new SubstitutionGroup(substitutionGroup);
        this.substitutionGroup = substitutionGroupObject.isDefined() ? substitutionGroupObject : null;
        DslBaseType dslBaseTypeObject = new DslBaseType(baseType);
        this.dslBaseType = dslBaseTypeObject.isDefined() ? dslBaseTypeObject : null;
    }

    public String getName() {
        return NAME;
    }

    public boolean allowsInlineDefinition() {
        return this.allowInlineDefinition;
    }

    public boolean allowsTopLevelDefinition() {
        return this.allowTopLevelDefinition;
    }

    public Optional<SubstitutionGroup> getSubstitutionGroup() {
        return Optional.ofNullable(this.substitutionGroup);
    }

    public Optional<DslBaseType> getDslBaseType() {
        return Optional.ofNullable(this.dslBaseType);
    }

    public int hashCode() {
        return Objects.hash(this.allowInlineDefinition, this.allowTopLevelDefinition, this.substitutionGroup, this.dslBaseType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDslAnnotation that = (TypeDslAnnotation)o;
        return this.allowInlineDefinition == that.allowInlineDefinition && this.allowTopLevelDefinition == that.allowTopLevelDefinition && Objects.equals(this.substitutionGroup, that.substitutionGroup) && Objects.equals(this.dslBaseType, that.dslBaseType);
    }
}

