/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.CachedClassTypeLoader;
import org.mule.runtime.extension.internal.ocs.PlatformManagedOAuthUtils;

public final class DefaultExtensionLoadingContext
implements ExtensionLoadingContext {
    private final ExtensionModelLoadingRequest request;
    private final ExtensionDeclarer extensionDeclarer;
    private final List<ExtensionModelValidator> customValidators = new LinkedList<ExtensionModelValidator>();
    private final List<DeclarationEnricher> customDeclarationEnrichers = new LinkedList<DeclarationEnricher>();
    private final Map<String, Object> customParameters;
    private final ClassTypeLoader typeLoader;

    public DefaultExtensionLoadingContext(ClassLoader extensionClassLoader, DslResolvingContext dslResolvingContext) {
        this(new ExtensionDeclarer(), ExtensionModelLoadingRequest.builder(extensionClassLoader, dslResolvingContext).build());
    }

    public DefaultExtensionLoadingContext(ExtensionDeclarer declarer, ClassLoader extensionClassLoader, DslResolvingContext dslResolvingContext) {
        this(declarer, ExtensionModelLoadingRequest.builder(extensionClassLoader, dslResolvingContext).build());
    }

    public DefaultExtensionLoadingContext(ExtensionModelLoadingRequest request) {
        this(new ExtensionDeclarer(), request);
    }

    public DefaultExtensionLoadingContext(ExtensionDeclarer extensionDeclarer, ExtensionModelLoadingRequest request) {
        Preconditions.checkArgument((extensionDeclarer != null ? 1 : 0) != 0, (String)"extension declarer cannot be null");
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"request cannot be null");
        this.extensionDeclarer = extensionDeclarer;
        this.typeLoader = new CachedClassTypeLoader(ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
        this.customParameters = new HashMap<String, Object>(request.getParameters());
        this.request = request;
    }

    @Override
    public ExtensionDeclarer getExtensionDeclarer() {
        return this.extensionDeclarer;
    }

    @Override
    public ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    @Override
    public void addParameter(String key, Object value) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (String)"key cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.customParameters.put(key, value);
    }

    @Override
    public void addParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (String)"cannot add null parameters");
        this.customParameters.putAll(parameters);
    }

    @Override
    public <T> Optional<T> getParameter(String key) {
        return Optional.ofNullable(this.customParameters.get(key));
    }

    @Override
    public ExtensionLoadingContext addCustomValidator(ExtensionModelValidator extensionModelValidator) {
        Preconditions.checkArgument((extensionModelValidator != null ? 1 : 0) != 0, (String)"custom validator cannot be null");
        this.customValidators.add(extensionModelValidator);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomValidators(Collection<ExtensionModelValidator> extensionModelValidators) {
        Preconditions.checkArgument((extensionModelValidators != null ? 1 : 0) != 0, (String)"custom validators cannot be null");
        this.customValidators.addAll(extensionModelValidators);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomDeclarationEnricher(DeclarationEnricher enricher) {
        Preconditions.checkArgument((enricher != null ? 1 : 0) != 0, (String)"custom enricher cannot be null");
        this.customDeclarationEnrichers.add(enricher);
        return this;
    }

    @Override
    public ExtensionLoadingContext addCustomDeclarationEnrichers(Collection<DeclarationEnricher> enrichers) {
        Preconditions.checkArgument((enrichers != null ? 1 : 0) != 0, (String)"custom enrichers cannot be null");
        this.customDeclarationEnrichers.addAll(enrichers);
        return this;
    }

    @Override
    public ClassLoader getExtensionClassLoader() {
        return this.request.getExtensionClassLoader();
    }

    @Override
    public DslResolvingContext getDslResolvingContext() {
        return this.request.getDslResolvingContext();
    }

    @Override
    public boolean isOCSEnabled() {
        return this.request.isOCSEnabled() || PlatformManagedOAuthUtils.isPlatformManagedOAuthEnabled();
    }

    @Override
    public boolean isForceExtensionValidation() {
        return this.request.isForceExtensionValidation();
    }

    @Override
    public boolean isResolveMinMuleVersion() {
        return this.request.isResolveMinMuleVersion();
    }

    @Override
    public Optional<ArtifactCoordinates> getArtifactCoordinates() {
        return Optional.ofNullable(this.request.getArtifactCoordinates());
    }

    @Override
    public List<DeclarationEnricher> getCustomDeclarationEnrichers() {
        ArrayList<DeclarationEnricher> enrichers = new ArrayList<DeclarationEnricher>(this.customDeclarationEnrichers.size() + this.request.getEnrichers().size());
        enrichers.addAll(this.customDeclarationEnrichers);
        enrichers.addAll(this.request.getEnrichers());
        return Collections.unmodifiableList(enrichers);
    }

    @Override
    public List<ExtensionModelValidator> getCustomValidators() {
        ArrayList<ExtensionModelValidator> validators = new ArrayList<ExtensionModelValidator>(this.customValidators.size() + this.request.getValidators().size());
        validators.addAll(this.customValidators);
        validators.addAll(this.request.getValidators());
        return Collections.unmodifiableList(validators);
    }
}

