/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.loader.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.dsl.DslConstants;

public class InfrastructureTypeUtils {
    public static final String TLS_KEY_STORE_PARAMETER_NAME = "KeyStore";
    public static final String TLS_TRUST_STORE_PARAMETER_NAME = "TrustStore";
    private static final ParameterDslConfiguration transactionalActionParameterDslConfiguration = ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build();
    private static final Collection<InfrastructureType> INFRASTRUCTURE_TYPES = Arrays.asList(new InfrastructureType("tlsContext", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "context", "tls")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(true).allowsReferences(true).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(TlsContextFactory.class, 8))), new InfrastructureType("custom-ocsp-responder", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "custom-ocsp-responder", "tls"))), new InfrastructureType("standard-revocation-check", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "standard-revocation-check", "tls"))), new InfrastructureType("crl-file", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "crl-file", "tls"))), new InfrastructureType("transactionalAction", transactionalActionParameterDslConfiguration, Arrays.asList(new MetadataTypeBasedInfrastructureTypeComponent(SourceTransactionalAction.class, 6), new MetadataTypeBasedInfrastructureTypeComponent(OperationTransactionalAction.class, 7), new MetadataTypeBasedInfrastructureTypeComponent(org.mule.sdk.api.tx.OperationTransactionalAction.class, 7))), new InfrastructureType("transactionType", ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(TransactionType.class, 9))), new InfrastructureType("schedulingStrategy", new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(SchedulingStrategy.class, 10))), new InfrastructureType("errorMappings", new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "error-mapping", "mule")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(ErrorMapping.class, 11))), new InfrastructureType("KeyStore", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "key-store", "tls")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(TlsContextKeyStoreConfiguration.class, 12))), new InfrastructureType("TrustStore", new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "trust-store", "tls")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.singletonList(new MetadataTypeBasedInfrastructureTypeComponent(TlsContextTrustStoreConfiguration.class, 13))), new InfrastructureType("repeatable-file-store-stream", new QNameModelProperty(new QName(DslConstants.EE_NAMESPACE, "repeatable-file-store-stream", "ee")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.emptyList()), new InfrastructureType("repeatable-in-memory-stream", new QNameModelProperty(new QName(DslConstants.EE_NAMESPACE, "repeatable-in-memory-stream", "ee")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.emptyList()), new InfrastructureType("non-repeatable-stream", new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "non-repeatable-stream", "mule")), ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build(), Collections.emptyList()));
    private static final Collection<MetadataTypeBasedInfrastructureType> METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES = INFRASTRUCTURE_TYPES.stream().flatMap(infrastructureType -> infrastructureType.getMetadataTypeBasedInfrastructureTypes().stream()).collect(Collectors.toList());
    private static final Map<Class<?>, MetadataTypeBasedInfrastructureType> METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES_CLASS_MAPPING = (Map)METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES.stream().collect(org.mule.runtime.api.util.collection.Collectors.toImmutableMap(MetadataTypeBasedInfrastructureType::getClazz, Function.identity()));
    private static final Map<ComponentIdentifier, Class<?>> IDENTIFIER_TYPE_MAPPING = (Map)METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES.stream().filter(infrastructureType -> infrastructureType.getQNameModelProperty().isPresent()).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableMap(infrastructureType -> {
        QName qName = infrastructureType.getQNameModelProperty().get().getValue();
        return ComponentIdentifier.builder().namespaceUri(qName.getNamespaceURI()).namespace(qName.getPrefix()).name(qName.getLocalPart()).build();
    }, MetadataTypeBasedInfrastructureType::getClazz));
    private static final Map<String, String> CLASS_NAME_MAP = (Map)METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES_CLASS_MAPPING.entrySet().stream().collect(org.mule.runtime.api.util.collection.Collectors.toImmutableMap(e -> ((Class)e.getKey()).getName(), e -> ((MetadataTypeBasedInfrastructureType)e.getValue()).getName()));
    private static final Map<String, InfrastructureType> NAME_MAP = (Map)INFRASTRUCTURE_TYPES.stream().collect(org.mule.runtime.api.util.collection.Collectors.toImmutableMap(InfrastructureType::getName, Function.identity()));

    public static Collection<MetadataTypeBasedInfrastructureType> getActionableInfrastructureTypes() {
        return METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES;
    }

    public static MetadataTypeBasedInfrastructureType getMetadataTypeBasedInfrastructureType(Class<?> infrastructureTypeClass) {
        return METADATA_TYPE_BASED_INFRASTRUCTURE_TYPES_CLASS_MAPPING.get(infrastructureTypeClass);
    }

    public static InfrastructureType getInfrastructureType(String name) {
        return NAME_MAP.get(name);
    }

    public static Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return ExtensionMetadataTypeUtils.getId(fieldType).map(CLASS_NAME_MAP::get);
    }

    public static Optional<Class<?>> getTypeFor(ComponentIdentifier compId) {
        return Optional.ofNullable(IDENTIFIER_TYPE_MAPPING.get(compId));
    }

    private InfrastructureTypeUtils() {
    }

    public static class MetadataTypeBasedInfrastructureType {
        private final String name;
        private final Class<?> clazz;
        private final int sequence;
        private final InfrastructureType parentType;

        MetadataTypeBasedInfrastructureType(String name, Class<?> clazz, int sequence, InfrastructureType parentType) {
            this.clazz = clazz;
            this.name = name;
            this.sequence = sequence;
            this.parentType = parentType;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }

        public Optional<QNameModelProperty> getQNameModelProperty() {
            return this.parentType.getQNameModelProperty();
        }

        public Optional<ParameterDslConfiguration> getDslConfiguration() {
            return this.parentType.getDslConfiguration();
        }
    }

    public static class InfrastructureType {
        private final String name;
        private final QNameModelProperty qNameModelProperty;
        private final ParameterDslConfiguration parameterDslConfiguration;
        private final Collection<MetadataTypeBasedInfrastructureType> metadataTypeBasedInfrastructureTypes;

        InfrastructureType(String name, QNameModelProperty qNameModelProperty, ParameterDslConfiguration parameterDslConfiguration, Collection<MetadataTypeBasedInfrastructureTypeComponent> actionableInfrastructureTypesComponents) {
            this.name = name;
            this.qNameModelProperty = qNameModelProperty;
            this.parameterDslConfiguration = parameterDslConfiguration;
            this.metadataTypeBasedInfrastructureTypes = actionableInfrastructureTypesComponents.stream().map(components -> new MetadataTypeBasedInfrastructureType(name, components.clazz, components.sequence, this)).collect(Collectors.toList());
        }

        InfrastructureType(String name, ParameterDslConfiguration parameterDslConfiguration, Collection<MetadataTypeBasedInfrastructureTypeComponent> actionableInfrastructureTypesComponents) {
            this(name, null, parameterDslConfiguration, actionableInfrastructureTypesComponents);
        }

        InfrastructureType(String name, QNameModelProperty qNameModelProperty) {
            this(name, qNameModelProperty, null, Collections.emptyList());
        }

        public String getName() {
            return this.name;
        }

        public Optional<QNameModelProperty> getQNameModelProperty() {
            return Optional.ofNullable(this.qNameModelProperty);
        }

        public Optional<ParameterDslConfiguration> getDslConfiguration() {
            return Optional.ofNullable(this.parameterDslConfiguration);
        }

        public Collection<MetadataTypeBasedInfrastructureType> getMetadataTypeBasedInfrastructureTypes() {
            return this.metadataTypeBasedInfrastructureTypes;
        }
    }

    private static class MetadataTypeBasedInfrastructureTypeComponent {
        public final Class<?> clazz;
        public final int sequence;

        MetadataTypeBasedInfrastructureTypeComponent(Class<?> clazz, int sequence) {
            this.clazz = clazz;
            this.sequence = sequence;
        }
    }
}

