/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.util.ExtensionValidationUtils;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;

public final class OperationModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        new ValidatorDelegate().validate(extensionModel, problemsReporter);
    }

    private static class ValidatorDelegate {
        private ProblemsReporter problemsReporter;
        private DslSyntaxResolver dsl;

        private ValidatorDelegate() {
        }

        void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
            this.problemsReporter = problemsReporter;
            this.dsl = DslSyntaxResolver.getDefault(extensionModel, new SingleExtensionImportTypesStrategy());
            final boolean hasGlobalConnectionProviders = !extensionModel.getConnectionProviders().isEmpty();
            final boolean extensionWithoutErrors = extensionModel.getErrorModels().isEmpty();
            new ExtensionWalker(){

                protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                    this.validateErrors(extensionModel, (ComponentModel)model, problemsReporter);
                    if (ExtensionModelUtils.isScope((ComponentModel)model)) {
                        this.validateScope((ComponentModel)model);
                    } else if (ExtensionModelUtils.isRouter(model)) {
                        this.validateRouter((ComponentModel)model);
                    }
                }

                protected void onOperation(HasOperationModels owner, OperationModel model) {
                    this.validateErrors(extensionModel, (ComponentModel)model, problemsReporter);
                    this.validateOutput(model);
                    this.validateConnection(owner, model, hasGlobalConnectionProviders);
                    if (ExtensionModelUtils.isScope((ComponentModel)model)) {
                        this.validateScope((ComponentModel)model);
                    } else if (ExtensionModelUtils.isRouter((ComponentModel)model)) {
                        this.validateRouter((ComponentModel)model);
                    }
                }

                private void validateErrors(ExtensionModel extensionModel2, ComponentModel componentModel, ProblemsReporter problemsReporter2) {
                    List undeclared;
                    if (extensionWithoutErrors && !componentModel.getErrorModels().isEmpty()) {
                        problemsReporter2.addError(new Problem((NamedObject)componentModel, String.format("%s '%s' declares error types but the Extension declares none", NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel), componentModel.getName())));
                    }
                    if (!(undeclared = componentModel.getErrorModels().stream().filter(error -> !extensionModel2.getErrorModels().contains(error)).collect(Collectors.toList())).isEmpty()) {
                        problemsReporter2.addError(new Problem((NamedObject)componentModel, String.format("%s '%s' declares error types which are not defined in the extension. Offending errors are [%s]", NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel), componentModel.getName(), undeclared.stream().map(ErrorModel::getType).collect(Collectors.joining(", ")))));
                    }
                }
            }.walk(extensionModel);
        }

        private void validateScope(ComponentModel model) {
            this.validateSingleNestedChain((ComposableModel)model, model, "Scope");
        }

        private void validateRouter(final ComponentModel model) {
            model.getNestedComponents().stream().forEach(nested -> nested.accept(new NestableElementModelVisitor(){

                public void visit(NestedComponentModel component) {
                }

                public void visit(NestedChainModel component) {
                    problemsReporter.addError(new Problem((NamedObject)model, "A Chain component was found along with one or more Route components. Mixed content is not allowed, either use all Routes or a single Chain"));
                }

                public void visit(NestedRouteModel route) {
                    this.validateRoute(route, model);
                }
            }));
        }

        private void validateRoute(NestedRouteModel route, ComponentModel model) {
            ExtensionValidationUtils.validateNoInlineParameters((ParameterizedModel)route, "Route", this.problemsReporter, this.dsl);
            this.validateSingleNestedChain((ComposableModel)route, model, "Route");
        }

        private void validateSingleNestedChain(final ComposableModel container, final ComponentModel model, final String kind) {
            final AtomicInteger numberOfChains = new AtomicInteger(0);
            container.getNestedComponents().forEach(nestedComponent -> nestedComponent.accept(new NestableElementModelVisitor(){

                public void visit(NestedComponentModel component) {
                }

                public void visit(NestedChainModel component) {
                    numberOfChains.incrementAndGet();
                }

                public void visit(NestedRouteModel nestedRoute) {
                    problemsReporter.addError(new Problem((NamedObject)model, String.format("Routes are not supported inside %s, but found Route [%s] nested as part of the %s [%s]", kind, nestedRoute.getName(), kind, container.getName())));
                }
            }));
            if (numberOfChains.get() == 0) {
                this.problemsReporter.addError(new Problem((NamedObject)model, String.format("A Chain component is required as part of the %s [%s] in operation [%s]", kind, container.getName(), model.getName())));
            } else if (numberOfChains.get() > 1) {
                this.problemsReporter.addError(new Problem((NamedObject)model, String.format("Only a single Chain component is supported as part of the %s [%s], remove redundant declarations", kind, container.getName())));
            }
        }

        private void validateConnection(HasOperationModels owner, OperationModel model, boolean hasGlobalConnectionProviders) {
            boolean connectable;
            if (ComponentDeclarationUtils.isConnectionProvisioningRequired((ConnectableComponentModel)model) && !(connectable = owner instanceof HasConnectionProviderModels ? hasGlobalConnectionProviders || !((HasConnectionProviderModels)owner).getConnectionProviders().isEmpty() : hasGlobalConnectionProviders)) {
                this.problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' requires a connection but no connection provider was defined at either the configuration or extension level", model.getName())));
            }
        }

        private void validateOutput(OperationModel model) {
            if (model.getOutput().getType() == null) {
                this.problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' does not define an output type", model.getName())));
            }
            if (model.getOutputAttributes().getType() == null) {
                this.problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' does not define an attributes output type", model.getName())));
            }
        }
    }
}

