/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ConfigOverrideTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.extension.internal.semantic.TypeSemanticTermsUtils;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;

final class ExtensionsObjectFieldHandler
implements ObjectFieldHandler {
    ExtensionsObjectFieldHandler() {
    }

    public void handleFields(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (clazz.getName().equals(Chain.class.getName())) {
            return;
        }
        Collection<Field> fields = TypeUtils.getParameterFields(clazz);
        if (fields.isEmpty()) {
            this.validateIllegalAnnotationUseOnNonParameterFields(clazz);
            this.fallbackToBeanProperties(clazz, typeHandlerManager, context, builder);
            return;
        }
        for (Field field : fields) {
            ObjectFieldTypeBuilder fieldBuilder = builder.addField();
            fieldBuilder.key(JavaParserUtils.getAlias(field));
            this.setOptionalAndDefault(field, fieldBuilder);
            this.processParameterGroup(field, fieldBuilder);
            this.processExpressionSupport(field, fieldBuilder);
            this.processNullSafe(clazz, field, fieldBuilder, typeHandlerManager, context);
            this.processElementStyle(field, fieldBuilder);
            this.processLayoutAnnotation(field, fieldBuilder);
            this.processDisplayAnnotation(field, fieldBuilder);
            this.processConfigOverride(field, fieldBuilder);
            this.processElementReference(field, fieldBuilder);
            this.processSemanticTerms(field, fieldBuilder);
            this.setFieldType(typeHandlerManager, context, field, fieldBuilder);
        }
    }

    private void validateIllegalAnnotationUseOnNonParameterFields(Class<?> clazz) {
        String annotationsPackageName = Parameter.class.getPackage().getName();
        List illegalFieldNames = TypeUtils.getAllFields(clazz).stream().filter(field -> Stream.of(field.getAnnotations()).anyMatch(a -> {
            Class<? extends Annotation> annotationType = a.annotationType();
            return annotationType.getName().contains(annotationsPackageName) && !annotationType.getSimpleName().equals(RefName.class.getSimpleName());
        })).map(Field::getName).collect(Collectors.toList());
        if (!illegalFieldNames.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("Class '%s' has fields which are not parameters but are annotated with Extensions API annotations. Illegal fields are " + illegalFieldNames, clazz.getName()));
        }
    }

    private void processParameterGroup(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        if (TypeUtils.isParameterGroup(field)) {
            fieldBuilder.with((TypeAnnotation)new FlattenedTypeAnnotation());
            this.processExclusiveOptionals(field, fieldBuilder);
        }
    }

    private void processExclusiveOptionals(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<Boolean> exclusiveOptionalsIsOneRequired = JavaParserUtils.getExclusiveOptionalsIsOneRequired(field.getType());
        if (exclusiveOptionalsIsOneRequired.isPresent()) {
            Set exclusiveParameters = TypeUtils.getParameterFields(field.getType()).stream().filter(TypeUtils::isOptional).map(JavaParserUtils::getAlias).collect(Collectors.toCollection(LinkedHashSet::new));
            fieldBuilder.with((TypeAnnotation)new ExclusiveOptionalsTypeAnnotation(exclusiveParameters, exclusiveOptionalsIsOneRequired.get()));
        }
    }

    private void processDisplayAnnotation(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<ClassValueModel> classValueModel;
        Optional<PathModel> pathModel;
        Optional<String> exampleValue;
        Optional<String> summaryValue;
        DisplayModel.DisplayModelBuilder builder = DisplayModel.builder();
        boolean shouldAddTypeAnnotation = false;
        Optional<String> displayName = TypeUtils.getDisplayName(field);
        if (displayName.isPresent()) {
            builder.displayName(displayName.get());
            shouldAddTypeAnnotation = true;
        }
        if ((summaryValue = TypeUtils.getSummaryValue(field)).isPresent()) {
            builder.summary(summaryValue.get());
            shouldAddTypeAnnotation = true;
        }
        if ((exampleValue = TypeUtils.getExampleValue(field)).isPresent()) {
            builder.example(exampleValue.get());
            shouldAddTypeAnnotation = true;
        }
        if ((pathModel = TypeUtils.getPathModel(field)).isPresent()) {
            builder.path(pathModel.get());
            shouldAddTypeAnnotation = true;
        }
        if ((classValueModel = TypeUtils.getClassValueModel(field)).isPresent()) {
            builder.classValue(classValueModel.get());
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with((TypeAnnotation)new DisplayTypeAnnotation(builder.build()));
        }
    }

    private void processLayoutAnnotation(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        LayoutModel.LayoutModelBuilder builder = LayoutModel.builder();
        boolean shouldAddTypeAnnotation = false;
        Optional<Pair<Integer, String>> value = TypeUtils.getPlacementValue(field);
        if (value.isPresent()) {
            builder.tabName((String)value.get().getSecond()).order(((Integer)value.get().getFirst()).intValue());
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isPasswordField(field)) {
            builder.asPassword();
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isTextField(field)) {
            builder.asText();
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isQueryField(field)) {
            builder.asQuery();
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with((TypeAnnotation)new LayoutTypeAnnotation(builder.build()));
        }
    }

    private void setFieldType(TypeHandlerManager typeHandlerManager, ParsingContext context, Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Type fieldType = field.getGenericType();
        Optional typeBuilder = context.getTypeBuilder(fieldType);
        if (typeBuilder.isPresent()) {
            fieldBuilder.value((TypeBuilder)typeBuilder.get());
        } else {
            typeHandlerManager.handle(fieldType, context, fieldBuilder.value());
        }
    }

    private void processExpressionSupport(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        fieldBuilder.with((TypeAnnotation)new ExpressionSupportAnnotation(JavaParserUtils.getExpressionSupport(field).orElse(ExpressionSupport.SUPPORTED)));
    }

    private void processSemanticTerms(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        TypeSemanticTermsUtils.enrichWithTypeAnnotation(field, (WithAnnotation)fieldBuilder);
    }

    private void processNullSafe(Class<?> declaringClass, Field field, ObjectFieldTypeBuilder fieldBuilder, TypeHandlerManager typeHandlerManager, ParsingContext context) {
        Optional<Class<?>> defaultImplementedType = JavaParserUtils.getNullSafeDefaultImplementedType(field);
        if (defaultImplementedType.isPresent()) {
            if (!TypeUtils.isOptional(field) && !TypeUtils.isParameterGroup(field)) {
                throw new IllegalParameterModelDefinitionException(String.format("Field '%s' in class '%s' is required but annotated with '@%s', which is redundant", field.getName(), declaringClass.getName(), NullSafe.class.getSimpleName()));
            }
            Class<?> defaultType = defaultImplementedType.get();
            if (defaultType.equals(Object.class)) {
                fieldBuilder.with((TypeAnnotation)new NullSafeTypeAnnotation(field.getType(), false));
            } else {
                fieldBuilder.with((TypeAnnotation)new NullSafeTypeAnnotation(defaultType, true));
                Optional typeBuilder = context.getTypeBuilder(defaultType);
                if (typeBuilder.isPresent()) {
                    fieldBuilder.with((TypeAnnotation)new DefaultImplementingTypeAnnotation(((TypeBuilder)typeBuilder.get()).build()));
                } else {
                    BaseTypeBuilder defaultTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
                    typeHandlerManager.handle(defaultType, context, defaultTypeBuilder);
                    fieldBuilder.with((TypeAnnotation)new DefaultImplementingTypeAnnotation(defaultTypeBuilder.build()));
                }
            }
        }
    }

    private void processConfigOverride(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        if (JavaParserUtils.isConfigOverride(field)) {
            fieldBuilder.required(false);
            fieldBuilder.with((TypeAnnotation)new ConfigOverrideTypeAnnotation());
        }
    }

    private void processElementReference(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        ConfigReference ref2;
        ConfigReferences references = field.getAnnotation(ConfigReferences.class);
        if (references != null) {
            Arrays.stream(references.value()).map(ref -> new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype((String)ref.name(), (String)ref.namespace()).withParent(MuleStereotypes.CONFIG).build()))).forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).with(arg_0));
        }
        if ((ref2 = field.getAnnotation(ConfigReference.class)) != null) {
            fieldBuilder.with((TypeAnnotation)new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype((String)ref2.name(), (String)ref2.namespace()).withParent(MuleStereotypes.CONFIG).build())));
        }
        if (field.getAnnotation(FlowReference.class) != null) {
            fieldBuilder.with((TypeAnnotation)new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.FLOW)));
        }
        if (field.getAnnotation(ObjectStoreReference.class) != null) {
            fieldBuilder.with((TypeAnnotation)new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.OBJECT_STORE)));
        }
    }

    private void processElementStyle(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl legacyAnnotation = field.getAnnotation(org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class);
        ParameterDsl sdkAnnotation = field.getAnnotation(ParameterDsl.class);
        if (legacyAnnotation != null && sdkAnnotation != null) {
            throw new IllegalModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", field.getName(), org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class.getName(), ParameterDsl.class.getName()));
        }
        if (legacyAnnotation != null) {
            fieldBuilder.with((TypeAnnotation)new ParameterDslAnnotation(legacyAnnotation.allowInlineDefinition(), legacyAnnotation.allowReferences()));
        } else if (sdkAnnotation != null) {
            fieldBuilder.with((TypeAnnotation)new ParameterDslAnnotation(sdkAnnotation.allowInlineDefinition(), sdkAnnotation.allowReferences()));
        }
    }

    private void setOptionalAndDefault(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<Content> contentAnnotation = Optional.ofNullable(field.getAnnotation(Content.class));
        fieldBuilder.required(true);
        contentAnnotation.ifPresent(content -> {
            if (content.primary()) {
                fieldBuilder.required(false);
                if (ExtensionModelUtils.getDefaultValue(field) == null) {
                    fieldBuilder.with((TypeAnnotation)new DefaultValueAnnotation("#[payload]"));
                }
            }
        });
        if (TypeUtils.isOptional(field)) {
            this.optionalField(fieldBuilder, (String)ExtensionModelUtils.getDefaultValue(field));
        }
        if (Boolean.class.isAssignableFrom(field.getType()) || Boolean.TYPE.isAssignableFrom(field.getType())) {
            fieldBuilder.required(false);
            if (ExtensionModelUtils.getDefaultValue(field) == null && !JavaParserUtils.isConfigOverride(field)) {
                fieldBuilder.with((TypeAnnotation)new DefaultValueAnnotation(String.valueOf(Boolean.FALSE)));
            }
        }
    }

    private void fallbackToBeanProperties(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (!clazz.isInterface()) {
            new DefaultObjectFieldHandler().handleFields(clazz, typeHandlerManager, context, builder);
        }
    }

    private void optionalField(ObjectFieldTypeBuilder fieldBuilder, String defaultValue) {
        fieldBuilder.required(false);
        if (defaultValue != null) {
            fieldBuilder.with((TypeAnnotation)new DefaultValueAnnotation(defaultValue));
        }
    }
}

