/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;

public class DynamicConfigDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getConfigurations().forEach(config -> {
            if (this.canBeDynamic((ConfigurationDeclaration)config)) {
                InfrastructureParameterBuilder.addExpirationPolicy(config);
            }
        });
    }

    private boolean canBeDynamic(ConfigurationDeclaration config) {
        if (this.hasAnyDynamic((ParameterizedDeclaration<?>)config)) {
            return true;
        }
        return config.getConnectionProviders().stream().anyMatch(this::hasAnyDynamic);
    }

    private boolean hasAnyDynamic(ParameterizedDeclaration<?> declaration) {
        return declaration.getAllParameters().stream().anyMatch(p -> ExtensionModelUtils.acceptsExpressions(p.getExpressionSupport()));
    }
}

