/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.sdk.api.tx.OperationTransactionalAction;

public final class InfrastructureTypeMapping {
    public static final String TLS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/tls";
    public static final String TLS_KEY_STORE_PARAMETER_NAME = "KeyStore";
    public static final String TLS_TRUST_STORE_PARAMETER_NAME = "TrustStore";
    private static final Map<Class<?>, InfrastructureType> MAPPING = ImmutableMap.builder().put(TlsContextFactory.class, (Object)new InfrastructureType("tlsContext", 8)).put(SourceTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 6)).put(org.mule.runtime.extension.api.tx.OperationTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 7)).put(OperationTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 7)).put(TransactionType.class, (Object)new InfrastructureType("transactionType", 9)).put(SchedulingStrategy.class, (Object)new InfrastructureType("schedulingStrategy", 10)).put(ErrorMapping.class, (Object)new InfrastructureType("errorMappings", 11)).put(TlsContextKeyStoreConfiguration.class, (Object)new InfrastructureType("KeyStore", 12)).put(TlsContextTrustStoreConfiguration.class, (Object)new InfrastructureType("TrustStore", 13)).build();
    private static final Map<String, QNameModelProperty> QNAMES = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule"))).put((Object)"errorMappings", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "error-mapping", "mule"))).put((Object)"tlsContext", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "context", "tls"))).put((Object)"custom-ocsp-responder", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "custom-ocsp-responder", "tls"))).put((Object)"standard-revocation-check", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "standard-revocation-check", "tls"))).put((Object)"crl-file", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "crl-file", "tls"))).put((Object)"KeyStore", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "key-store", "tls"))).put((Object)"TrustStore", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "trust-store", "tls"))).put((Object)"repeatable-file-store-stream", (Object)new QNameModelProperty(new QName(DslConstants.EE_NAMESPACE, "repeatable-file-store-stream", "ee"))).put((Object)"repeatable-in-memory-stream", (Object)new QNameModelProperty(new QName(DslConstants.EE_NAMESPACE, "repeatable-in-memory-stream", "ee"))).put((Object)"non-repeatable-stream", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "non-repeatable-stream", "mule"))).build();
    private static final Map<ComponentIdentifier, Class<?>> IDENTIFIER_TYPE_MAPPING = (Map)MAPPING.entrySet().stream().filter(entry -> InfrastructureTypeMapping.getQName(((InfrastructureType)entry.getValue()).getName()).isPresent()).collect(Collectors.toImmutableMap(entry -> {
        QName qName = InfrastructureTypeMapping.getQName(((InfrastructureType)entry.getValue()).getName()).get().getValue();
        return ComponentIdentifier.builder().namespaceUri(qName.getNamespaceURI()).namespace(qName.getPrefix()).name(qName.getLocalPart()).build();
    }, Map.Entry::getKey));
    private static final Map<String, ParameterDslConfiguration> DSL_CONFIGURATIONS = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"errorMappings", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"tlsContext", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(true).allowsReferences(true).build()).put((Object)"transactionalAction", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"transactionType", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"KeyStore", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"TrustStore", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"repeatable-file-store-stream", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"repeatable-in-memory-stream", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"non-repeatable-stream", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).build();
    private static Map<String, String> nameMap = (Map)MAPPING.entrySet().stream().collect(Collectors.toImmutableMap(e -> ((Class)e.getKey()).getName(), e -> ((InfrastructureType)e.getValue()).getName()));

    public static Map<Class<?>, InfrastructureType> getMap() {
        return MAPPING;
    }

    public static Map<String, String> getNameMap() {
        return nameMap;
    }

    public static Optional<QNameModelProperty> getQName(String name) {
        return Optional.ofNullable(QNAMES.get(name));
    }

    public static Optional<ParameterDslConfiguration> getDslConfiguration(String name) {
        return Optional.ofNullable(DSL_CONFIGURATIONS.get(name));
    }

    public static Optional<Class<?>> getTypeFor(ComponentIdentifier compId) {
        return Optional.ofNullable(IDENTIFIER_TYPE_MAPPING.get(compId));
    }

    private InfrastructureTypeMapping() {
    }

    public static class InfrastructureType {
        private final String name;
        private final int sequence;

        InfrastructureType(String name, int sequence) {
            this.name = name;
            this.sequence = sequence;
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

