/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;

public class BackPressureModelValidator
implements ExtensionModelValidator {
    private static final String ERROR_PREFIX = "backPressureStrategy parameter ";

    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onSource(SourceModel model) {
                model.getAllParameterModels().stream().filter(p -> "onCapacityOverload".equals(p.getName())).findAny().ifPresent(p -> BackPressureModelValidator.this.validateBackPressureStrategyParameter(model, p, problemsReporter));
            }
        }.walk(model);
    }

    private void validateBackPressureStrategyParameter(SourceModel source, ParameterModel parameter, ProblemsReporter problemsReporter) {
        String defaultValue;
        if (!(parameter.getType() instanceof StringType)) {
            this.reportInvalidEnum(source, problemsReporter);
            return;
        }
        String string = defaultValue = parameter.getDefaultValue() != null ? parameter.getDefaultValue().toString() : null;
        if (defaultValue == null) {
            problemsReporter.addError(new Problem((NamedObject)source, "backPressureStrategy parameter does not specify a default"));
        }
        this.extractEnumAnnotation(source, parameter, problemsReporter).ifPresent(enumAnnotation -> {
            if (defaultValue == null) {
                return;
            }
            List values = Stream.of(enumAnnotation.getValues()).map(Object::toString).collect(Collectors.toList());
            if (!values.contains(defaultValue)) {
                problemsReporter.addError(new Problem((NamedObject)source, "backPressureStrategy parameter has a default value which is not listed as an available option"));
            }
        });
    }

    private Optional<EnumAnnotation> extractEnumAnnotation(SourceModel source, ParameterModel parameter, ProblemsReporter problemsReporter) {
        if (!(parameter.getType() instanceof StringType)) {
            problemsReporter.addError(new Problem((NamedObject)source, "backPressureStrategy parameter is not a String"));
            return Optional.empty();
        }
        StringType type = (StringType)parameter.getType();
        EnumAnnotation enumAnnotation = type.getAnnotation(EnumAnnotation.class).orElse(null);
        if (enumAnnotation == null) {
            this.reportInvalidEnum(source, problemsReporter);
            return Optional.empty();
        }
        for (Object value : enumAnnotation.getValues()) {
            if (value == null) {
                this.reportInvalidEnum(source, problemsReporter);
                return Optional.of(enumAnnotation);
            }
            try {
                BackPressureMode.valueOf(value.toString());
            }
            catch (IllegalArgumentException e) {
                this.reportInvalidEnum(source, problemsReporter);
                return Optional.of(enumAnnotation);
            }
        }
        return Optional.of(enumAnnotation);
    }

    private void reportInvalidEnum(SourceModel source, ProblemsReporter problemsReporter) {
        problemsReporter.addError(new Problem((NamedObject)source, "backPressureStrategy parameter is not an enum of valid modes"));
    }
}

