/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.property.TargetModelProperty;

public final class TargetParameterDeclarationEnricher
implements DeclarationEnricher {
    private static final Map<String, Set<String>> blacklistedExtensionsOperations = ImmutableMap.of((Object)"ee", (Object)ImmutableSet.of((Object)"transform"), (Object)"cxf", (Object)ImmutableSet.of((Object)"simpleService", (Object)"jaxwsService", (Object)"proxyService", (Object)"simpleClient", (Object)"jaxwsClient", (Object)"proxyClient", (Object[])new String[0]));

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        String extensionName = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName();
        Set blacklistedOperationsNames = blacklistedExtensionsOperations.getOrDefault(extensionName, Collections.emptySet());
        new EnricherDelegate(blacklistedOperationsNames).enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private final Set<String> blacklistedOperationsNames;
        private MetadataType attributeType;
        private MetadataType targetValue;

        private EnricherDelegate(Set<String> blacklistedOperationsNames) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            this.attributeType = typeLoader.load(String.class);
            this.targetValue = typeLoader.load(String.class);
            this.blacklistedOperationsNames = blacklistedOperationsNames;
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            new IdempotentDeclarationWalker(){

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    if (EnricherDelegate.this.blacklistedOperationsNames.contains(declaration.getName())) {
                        return;
                    }
                    MetadataType outputType = declaration.getOutput().getType();
                    if (outputType == null) {
                        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not specify an output type", declaration.getName()));
                    }
                    if (!(outputType instanceof VoidType)) {
                        declaration.getParameterGroup("Output").addParameter(EnricherDelegate.this.declareTarget()).addParameter(EnricherDelegate.this.declareTargetValue());
                    }
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }

        private ParameterDeclaration declareTarget() {
            ParameterDeclaration parameter = new ParameterDeclaration("target");
            parameter.setDescription("The name of a variable on which the operation's output will be placed");
            parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            parameter.setRequired(false);
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(this.attributeType, false);
            parameter.setDisplayModel(DisplayModel.builder().displayName("Target Variable").build());
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            return parameter;
        }

        private ParameterDeclaration declareTargetValue() {
            ParameterDeclaration parameter = new ParameterDeclaration("targetValue");
            parameter.setDescription("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable");
            parameter.setExpressionSupport(ExpressionSupport.REQUIRED);
            parameter.setRequired(false);
            parameter.setDefaultValue((Object)"#[payload]");
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(this.targetValue, false);
            parameter.setDisplayModel(DisplayModel.builder().displayName("Target Value").build());
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            parameter.addModelProperty((ModelProperty)new TargetModelProperty());
            return parameter;
        }
    }
}

