/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.internal.dsl.DslConstants;

public class DefaultImportTypesStrategy
implements ImportTypesStrategy {
    private static final XmlDslModel MULE_XML_MODEL = XmlDslModel.builder().setPrefix("mule").setNamespace(DslConstants.CORE_NAMESPACE).setXsdFileName("mule.xsd").setSchemaLocation(DslConstants.CORE_SCHEMA_LOCATION).build();
    private final ExtensionModel extensionModel;
    private final DslResolvingContext context;
    private final Map<MetadataType, XmlDslModel> importedTypes;

    public DefaultImportTypesStrategy(ExtensionModel extensionModel, DslResolvingContext context) {
        this.extensionModel = extensionModel;
        this.context = context;
        this.importedTypes = this.generateImportedTypes();
    }

    private Map<MetadataType, XmlDslModel> generateImportedTypes() {
        HashMap<MetadataType, XmlDslModel> types = new HashMap<MetadataType, XmlDslModel>();
        this.extensionModel.getImportedTypes().stream().map(ImportedTypeModel::getImportedType).forEach(importedType -> MetadataTypeUtils.getTypeId((MetadataType)importedType).ifPresent(typeId -> {
            Optional extension = this.context.getExtensionForType(typeId);
            if (!extension.isPresent() && !this.isProvidedByMule((String)typeId)) {
                throw new IllegalArgumentException(String.format("Couldn't find type '%s' definition because its declaring extension wasn't present in the current context", typeId));
            }
            types.put((MetadataType)importedType, extension.map(ExtensionModel::getXmlDslModel).orElse(MULE_XML_MODEL));
        }));
        return types;
    }

    @Override
    public Map<MetadataType, XmlDslModel> getImportedTypes() {
        return this.importedTypes;
    }

    private boolean isProvidedByMule(String typeId) {
        return typeId.startsWith("org.mule.runtime") || typeId.startsWith("com.mulesoft.mule.runtime.");
    }
}

