/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.ImplicitConfigNameModelProperty;
import org.mule.runtime.extension.api.property.ManyImplicitConfigsModelProperty;
import org.mule.runtime.extension.internal.loader.enricher.ConfigRefDeclarationEnricher;

public class ImplicitConfigEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){
            private ConfigurationDeclaration defaultConfig = null;
            private Map<ComponentDeclaration, Set<Object>> result = new HashMap<ComponentDeclaration, Set<Object>>();

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                if (declaration.getName().equals("config")) {
                    this.defaultConfig = declaration;
                }
            }

            @Override
            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                this.resolve(owner, (ExecutableComponentDeclaration)declaration);
            }

            @Override
            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                this.resolve(owner, (ExecutableComponentDeclaration)declaration);
            }

            private void resolve(Object owner, ExecutableComponentDeclaration declaration) {
                this.result.computeIfAbsent((ComponentDeclaration)declaration, m -> new HashSet()).add(owner);
            }

            @Override
            public void onWalkFinished() {
                this.result.forEach((component, owners) -> {
                    List implicitConfigurationModels = owners.stream().map(owner -> {
                        if (owner instanceof ConfigurationDeclaration) {
                            return (ConfigurationDeclaration)owner;
                        }
                        return this.defaultConfig;
                    }).filter(owner -> owner != null).filter(ConfigRefDeclarationEnricher::canBeUsedImplicitly).collect(Collectors.toList());
                    if (implicitConfigurationModels.size() == 1) {
                        component.addModelProperty((ModelProperty)new ImplicitConfigNameModelProperty(((ConfigurationDeclaration)implicitConfigurationModels.get(0)).getName()));
                    }
                    if (implicitConfigurationModels.size() > 1) {
                        component.addModelProperty((ModelProperty)new ManyImplicitConfigsModelProperty());
                    }
                });
            }
        });
    }
}

