/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.parameter;

import java.util.Optional;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.sdk.api.annotation.MinMuleVersion;

@MinMuleVersion(value="4.1")
public enum OutboundCorrelationStrategy {
    AUTO{

        @Override
        public Optional<String> getOutboundCorrelationId(CorrelationInfo correlationInfo, String customCorrelationId) {
            if (correlationInfo.isOutboundCorrelationEnabled()) {
                return ALWAYS.getOutboundCorrelationId(correlationInfo, customCorrelationId);
            }
            return Optional.empty();
        }
    }
    ,
    ALWAYS{

        @Override
        public Optional<String> getOutboundCorrelationId(CorrelationInfo correlationInfo, String customCorrelationId) {
            return customCorrelationId != null ? Optional.of(customCorrelationId) : Optional.of(correlationInfo.getCorrelationId());
        }
    }
    ,
    NEVER{

        @Override
        public Optional<String> getOutboundCorrelationId(CorrelationInfo correlationInfo, String customCorrelationId) {
            return Optional.empty();
        }
    };


    public abstract Optional<String> getOutboundCorrelationId(CorrelationInfo var1, String var2);
}

