/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.FunctionalUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.api.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DefaultImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.LayoutOrderComparator;
import org.mule.runtime.extension.api.util.NameUtils;

public class XmlDslSyntaxResolver
implements DslSyntaxResolver {
    private static final DefaultStringType STRING_TYPE = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    private final ExtensionModel extensionModel;
    private final TypeCatalog typeCatalog;
    private final XmlDslModel languageModel;
    private final Map<NamedObject, String> sanitizedElementNames = new ConcurrentHashMap<NamedObject, String>();
    private final Map<String, DslElementSyntax> resolvedTypes = new ConcurrentHashMap<String, DslElementSyntax>();
    private final Map<MetadataType, XmlDslModel> importedTypes;
    private final Deque<String> typeResolvingStack = new ArrayDeque<String>();

    public XmlDslSyntaxResolver(ExtensionModel model, DslResolvingContext context) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = this.getTypeCatalog(model, context);
        this.importedTypes = new DefaultImportTypesStrategy(model, context).getImportedTypes();
    }

    public XmlDslSyntaxResolver(ExtensionModel model, ImportTypesStrategy importTypesStrategy) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(model));
        this.importedTypes = importTypesStrategy.getImportedTypes();
    }

    @Override
    public DslElementSyntax resolve(NamedObject component) {
        String elementName = this.sanitizedElementNames.computeIfAbsent(component, DslSyntaxUtils::getSanitizedElementName);
        return (DslElementSyntax)FunctionalUtils.computeIfAbsent(this.resolvedTypes, (Object)elementName, key -> {
            DslElementSyntaxBuilder dsl = DslElementSyntaxBuilder.create().withElementName(elementName).withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).supportsTopLevelDeclaration(component instanceof ConstructModel && ((ConstructModel)component).allowsTopLevelDeclaration()).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(ExtensionModelUtils.requiresConfig(this.extensionModel, component));
            if (component instanceof ComponentModel) {
                this.resolveComponentDsl((ComponentModel)component, dsl, false);
            } else {
                if (component instanceof ParameterizedModel) {
                    this.resolveParameterizedDsl((ParameterizedModel)component, dsl);
                }
                if (component instanceof HasConnectionProviderModels) {
                    ((HasConnectionProviderModels)component).getConnectionProviders().forEach(c -> dsl.containing(c.getName(), this.resolve((NamedObject)c)));
                }
            }
            return dsl.build();
        });
    }

    @Override
    public DslElementSyntax resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final ParameterDslConfiguration dslConfig = parameter.getDslConfiguration();
        final boolean isContent = ExtensionModelUtils.isContent(parameter);
        final Reference prefix = new Reference((Object)this.languageModel.getPrefix());
        final Reference namespace = new Reference((Object)this.languageModel.getNamespace());
        final Reference elementName = new Reference();
        final Optional<QName> customQName = this.getCustomQName(parameter);
        customQName.ifPresent(qName -> {
            elementName.set((Object)qName.getLocalPart());
            prefix.set((Object)qName.getPrefix());
            namespace.set((Object)qName.getNamespaceURI());
        });
        if (elementName.get() == null) {
            elementName.set((Object)this.sanitizedElementNames.computeIfAbsent((NamedObject)parameter, DslSyntaxUtils::getSanitizedElementName));
        }
        parameter.getType().accept(new MetadataTypeVisitor(){

            public void visitUnion(UnionType unionType) {
                boolean extensible = DslSyntaxUtils.isExtensible(parameter.getType());
                builder.asWrappedElement(extensible);
                if (extensible) {
                    XmlDslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslConfig);
                    builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get());
                    unionType.getTypes().forEach(type -> DslSyntaxUtils.getTypeId(type).ifPresent(typeId -> XmlDslSyntaxResolver.this.resolve((MetadataType)type).ifPresent(typeDsl -> builder.containing((String)typeId, (DslElementSyntax)typeDsl))));
                } else {
                    unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                if (isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    this.addAttribute();
                }
            }

            public void visitString(StringType stringType) {
                if (DslSyntaxUtils.isText(parameter) || isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    this.addAttribute();
                }
            }

            private void addAttribute() {
                builder.supportsAttributeDeclaration(true).supportsChildDeclaration(false);
                if (customQName.isPresent()) {
                    builder.withNamespace((String)prefix.get(), (String)namespace.get());
                    builder.withAttributeName((String)elementName.get());
                } else {
                    builder.withAttributeName(parameter.getName());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get());
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)arrayType, expressionSupport, dslConfig, isContent);
                boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInline || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (!isContent) {
                        genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), (String)prefix.get(), (String)namespace.get(), false));
                    }
                }
            }

            public void visitObject(ObjectType objectType) {
                XmlDslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslConfig);
                builder.withNamespace((String)prefix.get(), (String)namespace.get());
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    XmlDslSyntaxResolver.this.resolveMapDslFromParameter(objectType, builder, isContent, expressionSupport, dslConfig, parameter.getName(), (String)prefix.get(), (String)namespace.get(), XmlDslSyntaxResolver.this.skipComponent((EnrichableModel)parameter));
                } else {
                    builder.withElementName((String)elementName.get());
                    XmlDslModel importedObjectType = (XmlDslModel)XmlDslSyntaxResolver.this.importedTypes.get(objectType);
                    XmlDslSyntaxResolver.this.resolveObjectDslFromParameter(parameter, objectType, builder, isContent, dslConfig, expressionSupport, importedObjectType != null ? importedObjectType.getPrefix() : (String)prefix.get(), importedObjectType != null ? importedObjectType.getNamespace() : (String)namespace.get());
                }
            }

            private void addContentChildWithNoAttribute() {
                builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get()).supportsChildDeclaration(true).supportsAttributeDeclaration(false);
            }
        });
        return builder.build();
    }

    @Override
    public DslElementSyntax resolveInline(ParameterGroupModel group) {
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        builder.withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).withElementName(DslSyntaxUtils.getSanitizedElementName((NamedObject)group)).supportsAttributeDeclaration(false).supportsChildDeclaration(true).supportsTopLevelDeclaration(false);
        group.getParameterModels().forEach(parameter -> builder.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
        return builder.build();
    }

    @Override
    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return type instanceof ObjectType ? this.resolvePojoDsl((ObjectType)type) : Optional.empty();
    }

    private Optional<DslElementSyntax> resolvePojoDsl(ObjectType type) {
        boolean isSubtype = !this.typeCatalog.getSuperTypes(type).isEmpty();
        boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)type, this.typeCatalog);
        boolean supportTopLevelElement = DslSyntaxUtils.supportTopLevelElement((MetadataType)type);
        boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)type, ExpressionSupport.NOT_SUPPORTED);
        if (!supportsInlineDeclaration && isSubtype) {
            supportsInlineDeclaration = type.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsInlineDefinition).orElseGet(() -> DslSyntaxUtils.isInstantiable((MetadataType)type));
        }
        if (!(supportsInlineDeclaration || supportTopLevelElement || requiresWrapper || isSubtype)) {
            return Optional.empty();
        }
        Reference prefix = new Reference((Object)this.getPrefix((MetadataType)type));
        Reference namespace = new Reference((Object)this.getNamespace((MetadataType)type));
        Reference elementName = new Reference((Object)NameUtils.getTopLevelTypeName((MetadataType)type));
        this.getCustomQName((MetadataType)type).ifPresent(qName -> {
            prefix.set((Object)qName.getPrefix());
            namespace.set((Object)qName.getNamespaceURI());
            elementName.set((Object)qName.getLocalPart());
        });
        Optional<String> key = DslSyntaxUtils.getTypeKey((MetadataType)type, (String)prefix.get(), (String)namespace.get());
        if (!key.isPresent()) {
            return Optional.empty();
        }
        if (this.resolvedTypes.containsKey(key.get())) {
            return Optional.of(this.resolvedTypes.get(key.get()));
        }
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create().withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get()).supportsTopLevelDeclaration(supportTopLevelElement).supportsChildDeclaration(supportsInlineDeclaration).supportsAttributeDeclaration(false).asWrappedElement(requiresWrapper);
        Optional<String> typeId = DslSyntaxUtils.getTypeId((MetadataType)type);
        if (typeId.isPresent() && !this.typeResolvingStack.contains(typeId.get())) {
            if (supportTopLevelElement || supportsInlineDeclaration) {
                this.withStackControl(typeId.get(), () -> this.declareFieldsAsChilds(builder, type.getFields(), (String)prefix.get(), (String)namespace.get()));
            }
            DslElementSyntax dsl = builder.build();
            this.resolvedTypes.put(key.get(), dsl);
            return Optional.of(dsl);
        }
        return Optional.of(builder.build());
    }

    private void resolveComponentDsl(final ComponentModel component, final DslElementSyntaxBuilder dsl, boolean skipComponent) {
        if (!skipComponent) {
            dsl.supportsTopLevelDeclaration(false);
            this.resolveParameterizedDsl((ParameterizedModel)component, dsl);
        }
        component.accept(new ComponentModelVisitor(){

            public void visit(OperationModel operationModel) {
                XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)operationModel, dsl);
            }

            public void visit(SourceModel sourceModel) {
                sourceModel.getSuccessCallback().ifPresent(cb -> XmlDslSyntaxResolver.this.resolveParameterizedDsl((ParameterizedModel)cb, dsl));
                sourceModel.getErrorCallback().ifPresent(cb -> XmlDslSyntaxResolver.this.resolveParameterizedDsl((ParameterizedModel)cb, dsl));
            }

            public void visit(ConstructModel model) {
                XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, dsl);
            }

            public void visit(NestedComponentModel model) {
                XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, dsl);
            }

            public void visit(NestedChainModel model) {
                XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, dsl);
            }

            public void visit(NestedRouteModel model) {
                if (ExtensionModelUtils.supportsMultiple(model)) {
                    if (!XmlDslSyntaxResolver.this.skipComponent((EnrichableModel)model)) {
                        String childModelName = NameUtils.singularize(model.getName());
                        String childElementName = org.mule.runtime.api.util.NameUtils.hyphenize((String)childModelName);
                        DslElementSyntaxBuilder listOfRoutesDsl = DslElementSyntaxBuilder.create().withElementName(childElementName).withNamespace(XmlDslSyntaxResolver.this.languageModel.getPrefix(), XmlDslSyntaxResolver.this.languageModel.getNamespace()).supportsTopLevelDeclaration(false).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(false);
                        XmlDslSyntaxResolver.this.resolveParameterizedDsl((ParameterizedModel)component, listOfRoutesDsl);
                        XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, listOfRoutesDsl);
                        dsl.containing(childModelName, listOfRoutesDsl.build());
                    } else {
                        XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, dsl);
                    }
                } else {
                    XmlDslSyntaxResolver.this.processComposableModel((ComposableModel)model, dsl);
                }
            }
        });
    }

    private void processComposableModel(ComposableModel model, final DslElementSyntaxBuilder dsl) {
        model.getNestedComponents().forEach(child -> child.accept(new ComponentModelVisitor(){

            public void visit(OperationModel model) {
            }

            public void visit(SourceModel model) {
            }

            public void visit(ConstructModel model) {
            }

            public void visit(NestedComponentModel component) {
                XmlDslSyntaxResolver.this.resolveRecursiveComponent((ComponentModel)component, dsl);
            }

            public void visit(NestedChainModel component) {
                XmlDslSyntaxResolver.this.resolveRecursiveComponent((ComponentModel)component, dsl);
            }

            public void visit(NestedRouteModel component) {
                XmlDslSyntaxResolver.this.resolveRecursiveComponent((ComponentModel)component, dsl);
            }
        }));
    }

    private void resolveRecursiveComponent(ComponentModel componentModel, DslElementSyntaxBuilder parentDsl) {
        boolean skipComponent = this.skipComponent((EnrichableModel)componentModel);
        if (!skipComponent) {
            DslElementSyntaxBuilder dsl = DslElementSyntaxBuilder.create().withElementName(DslSyntaxUtils.getSanitizedElementName((NamedObject)componentModel)).withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).supportsTopLevelDeclaration(false).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(false);
            this.resolveComponentDsl(componentModel, dsl, skipComponent);
            parentDsl.containing(componentModel.getName(), dsl.build());
        } else {
            this.resolveComponentDsl(componentModel, parentDsl, skipComponent);
        }
    }

    private boolean skipComponent(EnrichableModel enrichableModel) {
        return enrichableModel.getModelProperty(NoWrapperModelProperty.class).isPresent();
    }

    private void resolveObjectDslFromParameter(ParameterModel parameter, ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ParameterDslConfiguration dslConfig, ExpressionSupport expressionSupport, String prefix, String namespace) {
        boolean requiresWrapper;
        boolean supportsInline;
        boolean supportsTopLevel;
        if (ExtensionModelUtils.isInfrastructure(parameter)) {
            supportsTopLevel = dslConfig.allowTopLevelDefinition();
            supportsInline = dslConfig.allowsInlineDefinition();
            requiresWrapper = DslSyntaxUtils.isExtensible((MetadataType)objectType);
        } else {
            supportsTopLevel = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, dslConfig);
            supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, dslConfig, isContent);
            requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)objectType, this.typeCatalog);
        }
        builder.supportsTopLevelDeclaration(supportsTopLevel);
        if ((supportsInline || requiresWrapper) && dslConfig.allowsInlineDefinition()) {
            builder.supportsChildDeclaration(true);
            if (requiresWrapper) {
                builder.asWrappedElement(true);
            } else if (!isContent) {
                this.declareFieldsAsChilds(builder, objectType.getFields(), prefix, namespace);
            }
        }
    }

    private void resolveMapDslFromParameter(ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ExpressionSupport expressionSupport, ParameterDslConfiguration dslModel, String name, String namespace, String namespaceUri, boolean skipWrapper) {
        boolean canBeUncountable = skipWrapper;
        String parameterName = isContent ? name : NameUtils.pluralize(name, canBeUncountable);
        builder.withElementName(org.mule.runtime.api.util.NameUtils.hyphenize((String)parameterName)).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, dslModel, isContent));
        if (!isContent) {
            objectType.getOpenRestriction().ifPresent(type -> type.accept(this.getMapValueTypeVisitor(builder, name, namespace, namespaceUri, dslModel, skipWrapper)));
        }
    }

    private void resolveParameterizedDsl(ParameterizedModel component, DslElementSyntaxBuilder dsl) {
        List inlineGroupedParameters = component.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> dsl.containing(group.getName(), this.resolveInline((ParameterGroupModel)group))).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        component.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(parameter -> dsl.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementSyntaxBuilder listBuilder, final String parameterName, final String namespace, final String namespaceUri, final boolean asItem) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                if (DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)objectType, XmlDslSyntaxResolver.this.typeCatalog)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslElementSyntaxBuilder.create().withNamespace(XmlDslSyntaxResolver.this.getPrefix((MetadataType)objectType), XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType)).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsAttributeDeclaration(false).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.NOT_SUPPORTED)).asWrappedElement(true).supportsTopLevelDeclaration(DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, ParameterDslConfiguration.getDefaultInstance())).build());
                } else if (DslSyntaxUtils.isValidBean(objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, XmlDslSyntaxResolver.this.resolve((MetadataType)objectType).get());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder genericBuilder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false);
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED);
                boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInline || requiresWrapper) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, namespaceUri, true));
                }
                listBuilder.withGeneric((MetadataType)arrayType, genericBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }
        };
    }

    private MetadataTypeVisitor getMapValueTypeVisitor(final DslElementSyntaxBuilder mapBuilder, final String parameterName, final String namespace, final String namespaceUri, final ParameterDslConfiguration dslModel, final boolean skipWrapper) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                if (skipWrapper) {
                    mapBuilder.containing("key", DslElementSyntaxBuilder.create().withAttributeName("key").build()).containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build());
                    return;
                }
                mapBuilder.withGeneric(metadataType, this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean requiresWrapperElement = DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)objectType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInlineDeclaration || requiresWrapperElement) {
                    DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition();
                    String namespace2 = XmlDslSyntaxResolver.this.getPrefix((MetadataType)objectType);
                    String namespaceUri2 = XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType);
                    DslElementSyntaxBuilder innerPojoDsl = DslElementSyntaxBuilder.create().withAttributeName("value").withNamespace(namespace2, namespaceUri2);
                    if (supportsInlineDeclaration) {
                        innerPojoDsl.withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsChildDeclaration(true);
                        ExtensionMetadataTypeUtils.getId((MetadataType)objectType).ifPresent(id -> XmlDslSyntaxResolver.this.withStackControl(id, () -> XmlDslSyntaxResolver.this.declareFieldsAsChilds(innerPojoDsl, objectType.getFields(), namespace2, namespaceUri2)));
                    } else {
                        innerPojoDsl.asWrappedElement(true);
                    }
                    valueEntry.containing("value", innerPojoDsl.build());
                    mapBuilder.withGeneric((MetadataType)objectType, valueEntry.build());
                } else {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build());
                MetadataType genericType = arrayType.getType();
                boolean genericSupportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean genericRequiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (genericSupportsInline || genericRequiresWrapper) {
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(valueEntry, parameterName, namespace, namespaceUri, true));
                }
                mapBuilder.withGeneric((MetadataType)arrayType, valueEntry.build());
            }

            private DslElementSyntaxBuilder createBaseValueEntryDefinition() {
                return DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(org.mule.runtime.api.util.NameUtils.hyphenize((String)NameUtils.singularize(parameterName))).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("key", DslElementSyntaxBuilder.create().withAttributeName("key").build());
            }
        };
    }

    private void addBeanDeclarationSupport(ObjectType objectType, Collection<ObjectFieldType> childFields, DslElementSyntaxBuilder builder, String namespace, String namespaceUri, boolean introspectObjectFields) {
        boolean supportsChildDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED);
        boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)objectType, this.typeCatalog);
        boolean supportsTopDeclaration = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType);
        builder.supportsChildDeclaration(supportsChildDeclaration || requiresWrapper).supportsTopLevelDeclaration(supportsTopDeclaration).asWrappedElement(requiresWrapper);
        if (introspectObjectFields && (supportsChildDeclaration || supportsTopDeclaration)) {
            this.declareFieldsAsChilds(builder, childFields, namespace, namespaceUri);
        }
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementSyntaxBuilder objectFieldBuilder, final String fieldName, final String fieldElementName, final String ownerNamespace, final String ownerNamespaceUri) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                objectFieldBuilder.withAttributeName(fieldName).supportsAttributeDeclaration(true).supportsTopLevelDeclaration(false).supportsChildDeclaration(false).requiresConfig(false);
            }

            public void visitUnion(UnionType unionType) {
                objectFieldBuilder.withElementName(fieldElementName).withNamespace(XmlDslSyntaxResolver.this.getPrefix((MetadataType)unionType, ownerNamespace), XmlDslSyntaxResolver.this.getNamespace((MetadataType)unionType, ownerNamespaceUri)).supportsAttributeDeclaration(false).supportsTopLevelDeclaration(false).supportsChildDeclaration(true).requiresConfig(false);
                boolean extensible = DslSyntaxUtils.isExtensible((MetadataType)unionType);
                objectFieldBuilder.asWrappedElement(extensible);
                unionType.getTypes().forEach(unionTypeItem -> {
                    String typeId = ExtensionMetadataTypeUtils.getId(unionTypeItem).orElse(null);
                    if (typeId != null) {
                        DslElementSyntaxBuilder unionTypeItemBuilder = DslElementSyntaxBuilder.create();
                        unionTypeItem.accept(XmlDslSyntaxResolver.this.getObjectFieldVisitor(unionTypeItemBuilder, typeId, typeId, ownerNamespace, ownerNamespaceUri));
                        objectFieldBuilder.containing(typeId, unionTypeItemBuilder.build());
                    }
                });
            }

            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName);
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.handleMapObject(objectType);
                } else {
                    objectFieldBuilder.withElementName(fieldElementName).withNamespace(XmlDslSyntaxResolver.this.getPrefix((MetadataType)objectType, ownerNamespace), XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType, ownerNamespaceUri));
                    String typeId = ExtensionMetadataTypeUtils.getId((MetadataType)objectType).orElse(null);
                    if (typeId != null && !XmlDslSyntaxResolver.this.typeResolvingStack.contains(typeId)) {
                        XmlDslSyntaxResolver.this.withStackControl(typeId, () -> {
                            List fields = objectType.getFields().stream().filter(f -> ExtensionMetadataTypeUtils.getId(f.getValue()).map(id -> !XmlDslSyntaxResolver.this.typeResolvingStack.contains(id)).orElse(true)).collect(Collectors.toList());
                            XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, fields, objectFieldBuilder, ownerNamespace, ownerNamespaceUri, true);
                        });
                    } else {
                        XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, Collections.emptyList(), objectFieldBuilder, ownerNamespace, ownerNamespaceUri, false);
                    }
                }
            }

            private void handleMapObject(ObjectType objectType) {
                objectFieldBuilder.withElementName(org.mule.runtime.api.util.NameUtils.hyphenize((String)NameUtils.pluralize(fieldName))).withNamespace(ownerNamespace, ownerNamespaceUri);
                objectFieldBuilder.supportsChildDeclaration(true);
                objectFieldBuilder.withGeneric((MetadataType)STRING_TYPE, DslElementSyntaxBuilder.create().withAttributeName("key").build());
                objectType.getOpenRestriction().ifPresent(type -> type.accept(XmlDslSyntaxResolver.this.getMapValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, ParameterDslConfiguration.getDefaultInstance(), false)));
            }

            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(fieldElementName).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType genericType = arrayType.getType();
                if (DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED) || XmlDslSyntaxResolver.this.isBaseType(genericType)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, false));
                }
            }
        };
    }

    private boolean isBaseType(MetadataType type) {
        final Reference isBaseType = new Reference((Object)false);
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                isBaseType.set((Object)XmlDslSyntaxResolver.this.typeCatalog.containsBaseType(objectType));
            }
        });
        return (Boolean)isBaseType.get();
    }

    private void declareFieldsAsChilds(DslElementSyntaxBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace, String namespaceUri) {
        ArrayList<ObjectFieldType> sortedFields = new ArrayList<ObjectFieldType>(fields);
        Collections.sort(sortedFields, LayoutOrderComparator.OBJECTS_FIELDS_BY_LAYOUT_ORDER);
        sortedFields.forEach(field -> {
            DslElementSyntaxBuilder fieldBuilder = DslElementSyntaxBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            MetadataType fieldValue = field.getValue();
            Reference fieldPrefix = new Reference((Object)namespace);
            Reference fieldNamespaceUri = new Reference((Object)namespaceUri);
            Reference elementName = new Reference((Object)org.mule.runtime.api.util.NameUtils.hyphenize((String)childName));
            if (DslSyntaxUtils.isFlattened(field, fieldValue)) {
                this.declareFieldsAsChilds(objectBuilder, ((ObjectType)fieldValue).getFields(), (String)fieldPrefix.get(), (String)fieldNamespaceUri.get());
            } else {
                if (DslSyntaxUtils.isText((MetadataType)field)) {
                    fieldBuilder.supportsAttributeDeclaration(false).supportsChildDeclaration(true).withElementName((String)elementName.get()).withNamespace((String)fieldPrefix.get(), (String)fieldNamespaceUri.get());
                } else {
                    this.getCustomQName(fieldValue).ifPresent(qName -> {
                        elementName.set((Object)qName.getLocalPart());
                        fieldPrefix.set((Object)qName.getPrefix());
                        fieldNamespaceUri.set((Object)qName.getNamespaceURI());
                    });
                    fieldValue.accept(this.getObjectFieldVisitor(fieldBuilder, childName, (String)elementName.get(), (String)fieldPrefix.get(), (String)fieldNamespaceUri.get()));
                    fieldBuilder.supportsAttributeDeclaration(DslSyntaxUtils.supportAttributeDeclaration((MetadataType)field));
                }
                objectBuilder.containing(childName, fieldBuilder.build());
            }
        });
    }

    private void addAttributeName(DslElementSyntaxBuilder builder, ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        if (this.supportsAttributeDeclaration(parameter, isContent, dslModel)) {
            builder.withAttributeName(parameter.getName());
        } else {
            builder.supportsAttributeDeclaration(false);
        }
    }

    private boolean supportsAttributeDeclaration(ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        return !isContent && (dslModel.allowsReferences() || !ExpressionSupport.NOT_SUPPORTED.equals((Object)parameter.getExpressionSupport()));
    }

    private String getPrefix(MetadataType type) {
        return this.getPrefix(type, this.languageModel.getPrefix());
    }

    private String getPrefix(MetadataType type, String prefix) {
        XmlDslModel originXml = this.lookupOriginXml(type);
        return originXml != null ? originXml.getPrefix() : prefix;
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.languageModel.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlDslModel originXml = this.lookupOriginXml(type);
        return originXml != null ? originXml.getNamespace() : defaultNamespace;
    }

    private XmlDslModel lookupOriginXml(MetadataType type) {
        return DslSyntaxUtils.getTypeId(type).flatMap(id -> this.typeCatalog.getType(id)).map(normalizedType -> this.importedTypes.get(normalizedType)).orElse(this.importedTypes.get(type));
    }

    private String resolveItemName(String parameterName, boolean forceItemize) {
        String singularizedName = NameUtils.singularize(parameterName);
        return forceItemize || parameterName.equals(singularizedName) ? NameUtils.itemize(singularizedName) : org.mule.runtime.api.util.NameUtils.hyphenize((String)singularizedName);
    }

    private TypeCatalog getTypeCatalog(ExtensionModel model, DslResolvingContext context) {
        return context.getExtension(model.getName()).isPresent() ? context.getTypeCatalog() : TypeCatalog.getDefault((Set)ImmutableSet.builder().add((Object)model).addAll((Iterable)context.getExtensions()).build());
    }

    private synchronized void withStackControl(String stackId, Runnable action) {
        if (!this.typeResolvingStack.contains(stackId)) {
            this.typeResolvingStack.push(stackId);
            action.run();
            this.typeResolvingStack.pop();
        }
    }

    private Optional<QName> getCustomQName(ParameterModel parameter) {
        return parameter.getModelProperty(QNameModelProperty.class).map(QNameModelProperty::getValue);
    }

    private Optional<QName> getCustomQName(MetadataType type) {
        return type.getAnnotation(QNameTypeAnnotation.class).map(QNameTypeAnnotation::getValue);
    }
}

