/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.nested;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.AbstractParameterizedModel;

public class ImmutableNestedRouteModel
extends AbstractParameterizedModel
implements NestedRouteModel {
    private final int minOccurs;
    private final Integer maxOccurs;
    private final List<? extends NestableElementModel> childComponents;

    public ImmutableNestedRouteModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, int minOccurs, Integer maxOccurs, List<? extends NestableElementModel> childComponents, Set<ModelProperty> modelProperties) {
        super(name, description, parameterGroupModels, displayModel, modelProperties);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.childComponents = childComponents == null ? ImmutableList.of() : ImmutableList.copyOf(childComponents);
    }

    public boolean isRequired() {
        return this.minOccurs > 0;
    }

    public void accept(NestableElementModelVisitor visitor) {
        visitor.visit((NestedRouteModel)this);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public Optional<Integer> getMaxOccurs() {
        return Optional.ofNullable(this.maxOccurs);
    }

    public List<? extends NestableElementModel> getNestedComponents() {
        return this.childComponents;
    }
}

