/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Set;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionTypesDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
        this.declareDefaultTypes(declarer);
        this.declareSubTypes(declarer);
    }

    private void declareSubTypes(ExtensionDeclarer declarer) {
        ((ExtensionDeclaration)declarer.getDeclaration()).getSubTypes().forEach(type -> this.registerTypes(declarer, type.getSubTypes()));
    }

    private void declareDefaultTypes(final ExtensionDeclarer declarer) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                ExtensionTypesDeclarationEnricher.this.registerType(declarer, declaration.getType());
            }

            @Override
            public void onSource(SourceDeclaration declaration) {
                ExtensionTypesDeclarationEnricher.this.registerType(declarer, (ExecutableComponentDeclaration)declaration);
            }

            @Override
            public void onOperation(OperationDeclaration declaration) {
                ExtensionTypesDeclarationEnricher.this.registerType(declarer, (ExecutableComponentDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)declarer.getDeclaration());
    }

    private void registerTypes(ExtensionDeclarer declarer, Set<ObjectType> types) {
        types.forEach(type -> this.registerType(declarer, (MetadataType)type));
    }

    private void registerType(ExtensionDeclarer declarer, ExecutableComponentDeclaration declaration) {
        if (declaration.getOutput() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify an output type", NameUtils.getComponentDeclarationTypeName((BaseDeclaration)declaration), declaration.getName()));
        }
        if (declaration.getOutputAttributes() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify output attributes types", NameUtils.getComponentDeclarationTypeName((BaseDeclaration)declaration), declaration.getName()));
        }
        this.registerType(declarer, declaration.getOutput().getType());
        this.registerType(declarer, declaration.getOutputAttributes().getType());
    }

    private void registerType(final ExtensionDeclarer declarer, MetadataType type) {
        if (!ExtensionMetadataTypeUtils.getId(type).isPresent() || type.getAnnotation(InfrastructureTypeAnnotation.class).isPresent()) {
            return;
        }
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                declarer.withType(objectType);
                objectType.getOpenRestriction().ifPresent(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }
        });
    }
}

