/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public final class OperationModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        final boolean hasGlobalConnectionProviders = !extensionModel.getConnectionProviders().isEmpty();
        new ExtensionWalker(){

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                OperationModelValidator.this.validateOutput(model, problemsReporter);
                OperationModelValidator.this.validateConnection(owner, model, hasGlobalConnectionProviders, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateConnection(HasOperationModels owner, OperationModel model, boolean hasGlobalConnectionProviders, ProblemsReporter problemsReporter) {
        boolean connectable;
        if (model.requiresConnection() && !(connectable = owner instanceof HasConnectionProviderModels ? hasGlobalConnectionProviders || !((HasConnectionProviderModels)owner).getConnectionProviders().isEmpty() : hasGlobalConnectionProviders)) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' requires a connection but no connection provider was defined at either the configuration or extension level", model.getName())));
        }
    }

    private void validateOutput(OperationModel model, ProblemsReporter problemsReporter) {
        if (model.getOutput().getType() == null) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' does not define an output type", model.getName())));
        }
        if (model.getOutputAttributes().getType() == null) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' does not define an attributes output type", model.getName())));
        }
    }
}

