/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class NameClashModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        new ValidationDelegate(model, problemsReporter).validate();
    }

    private List<ParameterModel> getContentParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(ExtensionModelUtils::isContent).collect(Collectors.toList());
    }

    private List<ParameterModel> filterContentParameters(List<ParameterModel> parameters) {
        return parameters.stream().filter(p -> !ExtensionModelUtils.isContent(p)).collect(Collectors.toList());
    }

    private static class ParameterReference {
        private final ParameterModel model;
        private final MetadataType type;
        private final ParameterizedModel owner;
        private final DslElementSyntax dsl;

        public ParameterReference(ParameterModel model, ParameterizedModel owner, DslElementSyntax dsl) {
            this.model = model;
            this.type = model.getType();
            this.owner = owner;
            this.dsl = dsl;
        }
    }

    private class DescribedParameter
    extends DescribedReference<ParameterModel> {
        private DescribedReference<? extends NamedObject> parent;
        private MetadataType describedType;

        private DescribedParameter(ParameterModel value, String elementName, ParameterizedModel parent, String parentElementName, MetadataType describedType) {
            super(NameClashModelValidator.this, (NamedObject)value, elementName);
            this.parent = new DescribedReference(NameClashModelValidator.this, (NamedObject)parent, parentElementName);
            this.describedType = describedType;
        }

        public MetadataType getDescribedType() {
            return this.describedType;
        }
    }

    private static class DescribedReference<T extends NamedObject>
    extends Reference<T>
    implements NamedObject,
    DescribedObject {
        private final String elementName;
        final /* synthetic */ NameClashModelValidator this$0;

        private DescribedReference(T value, String elementName) {
            this.this$0 = var1_1;
            super(value);
            this.elementName = elementName;
        }

        public String getName() {
            return this.elementName;
        }

        public String getDescription() {
            NamedObject value = (NamedObject)this.get();
            if (value instanceof ConfigurationModel) {
                return "configuration";
            }
            if (value instanceof OperationModel) {
                return "operation";
            }
            if (value instanceof SourceModel) {
                return "message source";
            }
            if (value instanceof ConnectionProviderModel) {
                return "connection provider";
            }
            return "";
        }

        public boolean equals(Object obj) {
            return obj instanceof DescribedReference && super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private class TypedTopLevelParameter
    extends TopLevelParameter {
        public TypedTopLevelParameter(TopLevelParameter parameter) {
            super(parameter.parameterModel, parameter.owner, parameter.ownerType);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        public boolean equals(Object obj) {
            return obj instanceof TypedTopLevelParameter && this.type.equals(((TypedTopLevelParameter)obj).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    private class TopLevelParameter
    extends Element {
        protected final ParameterModel parameterModel;
        protected final String owner;
        protected final String ownerType;

        public TopLevelParameter(ParameterModel parameterModel, String owner, String ownerType) {
            super(parameterModel.getName(), JavaTypeUtils.getType((MetadataType)parameterModel.getType()));
            this.parameterModel = parameterModel;
            this.owner = owner;
            this.ownerType = ownerType;
        }

        @Override
        public String toString() {
            return String.format("element named '%s' of type '%s' defined in %s '%s'", this.name, this.type.getSimpleName(), this.ownerType, this.owner);
        }
    }

    private class Element
    implements NamedObject,
    DescribedObject {
        protected final String name;
        protected final Class<?> type;

        private Element(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return "top level parameter";
        }

        public String toString() {
            return String.format("element %s of type %s", this.name, this.type.getSimpleName());
        }
    }

    private class ValidationDelegate {
        public static final String SINGULARIZED_CLASH_MESSAGE = "Extension '%s' contains %d parameters that clash when singularized. %s";
        public static final String NAME_CLASH_MESSAGE = "%s '%s' contains parameter '%s' that when transformed into DSL language clashes with parameter '%s'";
        private final ExtensionModel extensionModel;
        private final Set<DescribedReference<NamedObject>> namedObjects = new HashSet<DescribedReference<NamedObject>>();
        private final Map<String, DescribedParameter> singularizedObjects = new HashMap<String, DescribedParameter>();
        private final Multimap<String, TopLevelParameter> topLevelParameters = LinkedListMultimap.create();
        private final Multimap<String, Element> elements = LinkedListMultimap.create();
        private final List<ParameterReference> allContentParameters = new LinkedList<ParameterReference>();
        private final DslSyntaxResolver dslSyntaxResolver;
        private final ProblemsReporter problemsReporter;

        public ValidationDelegate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
            this.extensionModel = extensionModel;
            this.problemsReporter = problemsReporter;
            this.dslSyntaxResolver = DslSyntaxResolver.getDefault(extensionModel, new SingleExtensionImportTypesStrategy());
        }

        private void validate() {
            new ExtensionWalker(){

                public void onConfiguration(ConfigurationModel model) {
                    this.defaultValidation((ParameterizedModel)model);
                }

                public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                    this.defaultValidation((ParameterizedModel)model);
                }

                public void onOperation(HasOperationModels owner, OperationModel model) {
                    ValidationDelegate.this.validateOperation(model);
                    this.registerNamedObject((ParameterizedModel)model);
                    ValidationDelegate.this.validateSingularizedNameClash((ParameterizedModel)model, ValidationDelegate.this.dslSyntaxResolver.resolve((NamedObject)model).getElementName());
                    ValidationDelegate.this.registerContentParameters((ParameterizedModel)model);
                }

                public void onSource(HasSourceModels owner, SourceModel model) {
                    this.validateCallbackNames(model.getSuccessCallback(), model);
                    this.validateCallbackNames(model.getErrorCallback(), model);
                    this.defaultValidation((ParameterizedModel)model);
                    ValidationDelegate.this.registerContentParameters((ParameterizedModel)model);
                }

                public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                    ValidationDelegate.this.validateTopLevelParameter(model, owner);
                }

                private void defaultValidation(ParameterizedModel model) {
                    ValidationDelegate.this.validateNamesWithinGroups(model);
                    this.registerNamedObject(model);
                    ValidationDelegate.this.validateSingularizedNameClash(model, ValidationDelegate.this.dslSyntaxResolver.resolve((NamedObject)model).getElementName());
                }

                private void registerNamedObject(ParameterizedModel named) {
                    ValidationDelegate.this.namedObjects.add(new DescribedReference(NameClashModelValidator.this, (NamedObject)named, ValidationDelegate.this.dslSyntaxResolver.resolve((NamedObject)named).getElementName()));
                }

                private void validateCallbackNames(Optional<SourceCallbackModel> sourceCallback, SourceModel model) {
                    sourceCallback.ifPresent(cb -> ValidationDelegate.this.validateNamesWithinGroups((ParameterizedModel)cb, Stream.concat(model.getParameterGroupModels().stream(), cb.getParameterGroupModels().stream()).collect(Collectors.toList())));
                }
            }.walk(this.extensionModel);
            this.validateSubtypes(this.extensionModel.getSubTypes());
            this.validateSingularizeNameClashesWithTopLevels();
            this.validateSingularizeNameClashesWithNamedObjects();
            this.validateNameClashes(this.namedObjects, this.elements.values(), this.elements.values().stream().filter(e -> e instanceof TopLevelParameter).map(e -> new TypedTopLevelParameter((TopLevelParameter)e)).collect(Collectors.toSet()));
            this.validateContentNamesMatchType(this.extensionModel, this.problemsReporter);
        }

        private void validateSubtypes(Set<SubTypesModel> subTypes) {
            subTypes.forEach(subTypesModel -> subTypesModel.getSubTypes().forEach(type -> ExtensionMetadataTypeUtils.getType((MetadataType)type).ifPresent(parameterType -> this.dslSyntaxResolver.resolve((MetadataType)type).filter(DslElementSyntax::supportsChildDeclaration).ifPresent(subtypeElement -> {
                if (this.elements.containsKey((Object)subtypeElement.getElementName())) {
                    this.elements.get((Object)subtypeElement.getElementName()).stream().filter(element -> !element.type.equals(parameterType)).findAny().ifPresent(tp -> this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format("An extension subtype '%s' of complex type '%s' is defined. However, there is already an element with the same name but with a different type (%s). Complex parameter of different types cannot have the same name.", subtypeElement.getElementName(), parameterType, tp.toString()))));
                }
                this.validateType((MetadataType)type, (Class<?>)parameterType, (DslElementSyntax)subtypeElement);
            }))));
        }

        private void validateType(MetadataType type, final Class<?> parameterType, final DslElementSyntax elementSyntax) {
            type.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    objectType.getFields().forEach(field -> {
                        String fieldName = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
                        elementSyntax.getChild(fieldName).ifPresent(child -> ValidationDelegate.this.validateInnerFields(fieldName, field.getValue(), parameterType.getSimpleName(), child));
                    });
                }

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }
            });
        }

        private void registerContentParameters(ParameterizedModel model) {
            NameClashModelValidator.this.getContentParameters(model).stream().map(p -> new ParameterReference((ParameterModel)p, model, this.dslSyntaxResolver.resolve((ParameterModel)p))).forEach(this.allContentParameters::add);
        }

        private void validateOperation(OperationModel operation) {
            this.validateNamesWithinGroups((ParameterizedModel)operation);
            String operationName = this.dslSyntaxResolver.resolve((NamedObject)operation).getElementName();
            operation.getAllParameterModels().stream().map(parameterModel -> this.dslSyntaxResolver.resolve((ParameterModel)parameterModel)).filter(DslElementSyntax::supportsChildDeclaration).forEach(parameterElement -> {
                this.validateClash(operationName, parameterElement.getElementName(), NameUtils.getComponentModelTypeName((ParameterizedModel)operation), "argument");
                this.namedObjects.forEach(namedObject -> this.validateClash(namedObject.getName(), parameterElement.getElementName(), namedObject.getDescription(), String.format("%s named %s with an argument", operationName, NameUtils.getComponentModelTypeName((ParameterizedModel)operation))));
            });
        }

        private void validateParameterNames(List<ParameterModel> parameterizedModel, String modelTypeName, String modelName) {
            Set<String> repeatedParameters = this.collectRepeatedNames(parameterizedModel);
            if (!repeatedParameters.isEmpty()) {
                this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format("The %s '%s' has parameters with repeated names. Offending parameters are: [%s]", modelTypeName, modelName, Joiner.on((String)",").join(repeatedParameters))));
            }
        }

        private void validateTopLevelParameter(ParameterModel parameter, ParameterizedModel owner) {
            this.validateTopLevelParameter(parameter, owner, this.dslSyntaxResolver.resolve(parameter));
        }

        private void validateTopLevelParameter(ParameterModel parameter, ParameterizedModel owner, DslElementSyntax parameterElement) {
            if (parameterElement.supportsChildDeclaration()) {
                Class parameterType = ExtensionMetadataTypeUtils.getType(parameter.getType()).orElse(null);
                if (parameterType == null) {
                    return;
                }
                String ownerName = owner.getName();
                String ownerType = NameUtils.getComponentModelTypeName(owner);
                Collection foundParameters = this.elements.get((Object)parameterElement.getElementName());
                if (foundParameters.isEmpty()) {
                    this.elements.put((Object)parameterElement.getElementName(), (Object)new TopLevelParameter(parameter, ownerName, ownerType));
                } else {
                    foundParameters.stream().filter(topLevelParameter -> !topLevelParameter.type.equals(parameterType)).findAny().ifPresent(tp -> this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format("An %s of name '%s' contains parameter '%s' of complex type '%s'. However, there is already an element with the same name but with a different type (%s). Complex parameter of different types cannot have the same name.", ownerType, ownerName, parameterElement.getElementName(), parameterType, tp.toString()))));
                }
                this.validateType(parameter.getType(), parameterType, parameterElement);
            }
        }

        private void validateInnerFields(String name, MetadataType fieldType, String parentType, DslElementSyntax parameterElement) {
            if (parameterElement.supportsChildDeclaration()) {
                ExtensionMetadataTypeUtils.getType(fieldType).ifPresent(parameterType -> {
                    Collection foundParameters = this.elements.get((Object)parameterElement.getElementName());
                    if (foundParameters.isEmpty()) {
                        this.elements.put((Object)parameterElement.getElementName(), (Object)new Element(name, (Class)parameterType));
                    } else {
                        foundParameters.stream().filter(topLevelParameter -> !topLevelParameter.type.equals(parameterType)).findAny().ifPresent(tp -> this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format("Object of type %s contains a field named '%s' of complex type '%s'. However, there is already an element with the same name but with a different type (%s). Complex parameter of different types cannot have the same name.", parentType, parameterElement.getElementName(), parameterType, tp.toString()))));
                    }
                    this.validateType(fieldType, (Class<?>)parameterType, parameterElement);
                });
            }
        }

        private Set<String> collectRepeatedNames(List<? extends NamedObject> namedObject) {
            HashSet names = new HashSet();
            return namedObject.stream().map(parameter -> this.dslSyntaxResolver.resolve((NamedObject)parameter).getElementName()).filter(parameter -> !names.add(parameter)).collect(Collectors.toSet());
        }

        private void validateNameClashes(Collection<? extends NamedObject> ... collections) {
            LinkedListMultimap names = LinkedListMultimap.create();
            Arrays.stream(collections).flatMap(Collection::stream).forEach(arg_0 -> this.lambda$validateNameClashes$19((Multimap)names, arg_0));
            this.validateNameClashBetweenElements((Multimap<String, NamedObject>)names);
        }

        private void validateNameClashBetweenElements(Multimap<String, NamedObject> names) {
            names.asMap().entrySet().forEach(entry -> {
                List values = (List)entry.getValue();
                if (values.size() > 1) {
                    Set offendingTypes = values.stream().map(NamedObject::getName).collect(Collectors.toSet());
                    StringBuilder errorMessage = new StringBuilder(String.format("Extension '%s' contains %d components ", this.extensionModel.getName(), values.size()));
                    int top = offendingTypes.size() - 1;
                    int i = 0;
                    for (String offender : offendingTypes) {
                        errorMessage.append(String.format("'%s'", offender));
                        if (i + 1 == top) {
                            errorMessage.append(" and ");
                        } else if (i != top) {
                            errorMessage.append(", ");
                        }
                        ++i;
                    }
                    errorMessage.append(String.format(" which it's transformed DSL name is '%s'. DSL Names should be unique", entry.getKey()));
                    this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, errorMessage.toString()));
                }
            });
        }

        private void validateSingularizeNameClashesWithTopLevels() {
            Map singularClashes = this.elements.keySet().stream().filter(k -> this.singularizedObjects.containsKey(k) && !this.elements.get(k).isEmpty()).collect(Collectors.toMap(Function.identity(), arg_0 -> this.elements.get(arg_0)));
            if (!singularClashes.isEmpty()) {
                ArrayList errorMessages = new ArrayList();
                singularClashes.entrySet().forEach(e -> {
                    DescribedParameter reference = this.singularizedObjects.get(e.getKey());
                    ((Collection)e.getValue()).stream().filter(tp -> !Objects.equals(JavaTypeUtils.getType((MetadataType)reference.getDescribedType()), tp.type)).forEach(tp -> errorMessages.add(String.format(NAME_CLASH_MESSAGE, reference.parent.getDescription(), reference.parent.getName(), reference.getName(), tp.toString())));
                });
                if (!errorMessages.isEmpty()) {
                    this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format(SINGULARIZED_CLASH_MESSAGE, this.extensionModel.getName(), singularClashes.size(), errorMessages.stream().collect(Collectors.joining(", ")))));
                }
            }
        }

        private void validateSingularizeNameClashesWithNamedObjects() {
            Set<DescribedReference> singularClashes = this.namedObjects.stream().filter(k -> this.singularizedObjects.containsKey(k.getName())).collect(Collectors.toSet());
            if (!singularClashes.isEmpty()) {
                ArrayList errorMessages = new ArrayList();
                singularClashes.forEach(namedObject -> {
                    DescribedParameter reference = this.singularizedObjects.get(namedObject.getName());
                    errorMessages.add(String.format(NAME_CLASH_MESSAGE, reference.parent.getDescription(), reference.parent.getName(), reference.getName(), namedObject.getDescription()));
                });
                if (!errorMessages.isEmpty()) {
                    this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format(SINGULARIZED_CLASH_MESSAGE, this.extensionModel.getName(), singularClashes.size(), errorMessages.stream().collect(Collectors.joining(", ")))));
                }
            }
        }

        private void validateClash(String existingNamingModel, String newNamingModel, String typeOfExistingNamingModel, String typeOfNewNamingModel) {
            if (existingNamingModel != null && existingNamingModel.equalsIgnoreCase(newNamingModel)) {
                this.problemsReporter.addError(new Problem((NamedObject)this.extensionModel, String.format("Extension '%s' has a %s named '%s' and an %s type named equally.", this.extensionModel.getName(), typeOfExistingNamingModel, existingNamingModel, typeOfNewNamingModel)));
            }
        }

        private void validateContentNamesMatchType(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
            HashMap<String, List> clashingsByTagName = new HashMap<String, List>();
            this.allContentParameters.forEach(param -> clashingsByTagName.computeIfAbsent(((ParameterReference)param).dsl.getElementName(), k -> {
                List others = this.allContentParameters.stream().filter(other -> ((ParameterReference)param).dsl.getElementName().equals(((ParameterReference)other).dsl.getElementName()) && !((ParameterReference)param).type.equals(((ParameterReference)other).type)).collect(Collectors.toList());
                if (!others.isEmpty()) {
                    others.add(param);
                }
                return others;
            }));
            clashingsByTagName.forEach((tag, invalidParams) -> {
                if (!invalidParams.isEmpty()) {
                    String msg = String.format("Parameters with name [%s] declared in [%s] with tag name [%s] are declared as Content but have different types [%s]", ((ParameterReference)invalidParams.get(0)).model.getName(), invalidParams.stream().map(p -> ((ParameterReference)p).owner.getName()).collect(Collectors.joining(", ")), tag, invalidParams.stream().map(p -> ExtensionMetadataTypeUtils.getId(((ParameterReference)p).type).orElse("")).filter(StringUtils::isBlank).collect(Collectors.joining(", ")));
                    problemsReporter.addError(new Problem((NamedObject)extensionModel, msg));
                }
            });
        }

        private void validateNamesWithinGroups(ParameterizedModel model) {
            this.validateNamesWithinGroups(model, model.getParameterGroupModels());
        }

        private void validateNamesWithinGroups(ParameterizedModel model, List<ParameterGroupModel> groups) {
            String componentTypeName = NameUtils.getComponentModelTypeName(model);
            MultiMap parametersMap = new MultiMap();
            groups.forEach(group -> {
                ParameterGroupModel parameterContainer = group.isShowInDsl() ? group : model;
                group.getParameterModels().forEach(arg_0 -> ValidationDelegate.lambda$null$33(parametersMap, (NamedObject)parameterContainer, arg_0));
            });
            parametersMap.keySet().forEach(parameterContainer -> this.validateParameterNames(parametersMap.getAll(parameterContainer), componentTypeName, model.getName()));
        }

        private void validateSingularizedNameClash(ParameterizedModel model, String modelElementName) {
            List parameters = NameClashModelValidator.this.filterContentParameters(model.getAllParameterModels());
            parameters.forEach(parameter -> parameter.getType().accept(new MetadataTypeVisitor((ParameterModel)parameter, model, modelElementName, parameters){
                final /* synthetic */ ParameterModel val$parameter;
                final /* synthetic */ ParameterizedModel val$model;
                final /* synthetic */ String val$modelElementName;
                final /* synthetic */ List val$parameters;
                {
                    this.val$parameter = parameterModel;
                    this.val$model = parameterizedModel;
                    this.val$modelElementName = string;
                    this.val$parameters = list;
                }

                public void visitObject(ObjectType objectType) {
                    objectType.getOpenRestriction().ifPresent(this::validateSingularizedChildName);
                }

                public void visitArrayType(ArrayType arrayType) {
                    this.validateSingularizedChildName(arrayType.getType());
                }

                private void validateSingularizedChildName(MetadataType type) {
                    DslElementSyntax parameterSyntax = ValidationDelegate.this.dslSyntaxResolver.resolve(this.val$parameter);
                    String describedReference = new DescribedReference(NameClashModelValidator.this, (NamedObject)this.val$model, this.val$modelElementName).getDescription();
                    parameterSyntax.getGeneric(type).filter(t -> parameterSyntax.supportsChildDeclaration()).ifPresent(childSyntax -> {
                        ValidationDelegate.this.singularizedObjects.put(childSyntax.getElementName(), new DescribedParameter(this.val$parameter, parameterSyntax.getElementName(), this.val$model, this.val$modelElementName, type));
                        this.val$parameters.stream().filter(p -> Objects.equals(ValidationDelegate.this.dslSyntaxResolver.resolve((ParameterModel)p).getElementName(), childSyntax.getElementName())).filter(p -> !Objects.equals(JavaTypeUtils.getType((MetadataType)p.getType()), JavaTypeUtils.getType((MetadataType)type))).findAny().ifPresent(clashParam -> ValidationDelegate.this.problemsReporter.addError(new Problem((NamedObject)ValidationDelegate.this.extensionModel, String.format("Extension '%s' defines an %s of name '%s' which contains a parameter '%s' that when transformed toDSL language clashes with another parameter '%s' in the same %s", ValidationDelegate.this.extensionModel.getName(), describedReference, this.val$model.getName(), this.val$parameter.getName(), clashParam.getName(), describedReference))));
                    });
                }
            }));
        }

        private static /* synthetic */ void lambda$null$33(MultiMap parametersMap, NamedObject parameterContainer, ParameterModel parameter) {
            ParameterModel cfr_ignored_0 = (ParameterModel)parametersMap.put((Object)parameterContainer, (Object)parameter);
        }

        private /* synthetic */ void lambda$validateNameClashes$19(Multimap names, NamedObject named) {
            names.put((Object)this.dslSyntaxResolver.resolve(named).getElementName(), (Object)named);
        }
    }
}

