/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class NameUtils {
    public static final String CONFIGURATION = "configuration";
    public static final String OPERATION = "operation";
    public static final String CONNECTION_PROVIDER = "connection provider";
    public static final String SOURCE = "source";
    public static final String SOURCE_CALLBACK = "source callback";
    public static final String FUNCTION = "function";
    public static final String CONSTRUCT = "construct";
    private static final List<Inflection> plural = new ArrayList<Inflection>();
    private static final List<Inflection> singular = new ArrayList<Inflection>();
    private static final List<String> uncountable = new ArrayList<String>();

    private NameUtils() {
    }

    private static void plural(String pattern, String replacement) {
        plural.add(0, new Inflection(pattern, replacement));
    }

    private static void singular(String pattern, String replacement) {
        singular.add(0, new Inflection(pattern, replacement));
    }

    private static void irregular(String s, String p) {
        NameUtils.plural("(" + s.substring(0, 1) + ")" + s.substring(1) + "$", "$1" + p.substring(1));
        NameUtils.singular("(" + p.substring(0, 1) + ")" + p.substring(1) + "$", "$1" + s.substring(1));
    }

    private static void uncountable(String word) {
        uncountable.add(word);
    }

    public static String hyphenize(String camelCaseName) {
        if (StringUtils.isBlank((CharSequence)camelCaseName)) {
            return camelCaseName;
        }
        StringBuilder result = new StringBuilder();
        String[] parts = camelCaseName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (int i = 0; i < parts.length; ++i) {
            result.append(parts[i].trim().toLowerCase() + (i < parts.length - 1 ? "-" : ""));
        }
        return result.toString();
    }

    public static String pluralize(String word) {
        if (NameUtils.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : plural) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String singularize(String word) {
        if (NameUtils.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : singular) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String itemize(String word) {
        return StringUtils.isBlank((CharSequence)word) ? word : NameUtils.hyphenize(word).concat("-item");
    }

    public static boolean isUncountable(String word) {
        if (StringUtils.isBlank((CharSequence)word)) {
            for (String w : uncountable) {
                if (!w.equalsIgnoreCase(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTopLevelTypeName(MetadataType metadataType) {
        return NameUtils.hyphenize(NameUtils.getAliasName(metadataType));
    }

    public static String getAliasName(MetadataType metadataType) {
        Supplier<IllegalArgumentException> exceptionSupplier = () -> new IllegalArgumentException("No name available for the given type");
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElseGet(() -> ExtensionMetadataTypeUtils.getId(metadataType).map(typeId -> ExtensionMetadataTypeUtils.getType(metadataType).map(t -> NameUtils.getAliasName(t)).orElse((String)typeId)).orElseThrow(exceptionSupplier));
    }

    public static String getAliasName(Class<?> type) {
        return NameUtils.getAliasName(type.getSimpleName(), type.getAnnotation(Alias.class));
    }

    public static String getAliasName(Field field) {
        return NameUtils.getAliasName(field.getName(), field.getAnnotation(Alias.class));
    }

    public static String getAliasName(Parameter parameter) {
        return NameUtils.getAliasName(parameter.getName(), parameter.getAnnotation(Alias.class));
    }

    public static String getAliasName(String defaultName, Alias aliasAnnotation) {
        String alias = aliasAnnotation != null ? aliasAnnotation.value() : null;
        return StringUtils.isEmpty((CharSequence)alias) ? defaultName : alias;
    }

    public static String defaultNamespace(String extensionName) {
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            throw new IllegalArgumentException("No Namespace can be created from an empty name");
        }
        String namespace = StringUtils.deleteWhitespace((String)extensionName);
        namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"extension");
        namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"connector");
        return NameUtils.hyphenize(StringUtils.isBlank((CharSequence)(namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"module"))) ? extensionName : namespace);
    }

    public static String getComponentModelTypeName(ParameterizedModel component) {
        if (component instanceof OperationModel) {
            return OPERATION;
        }
        if (component instanceof ConfigurationModel) {
            return CONFIGURATION;
        }
        if (component instanceof ConnectionProviderModel) {
            return CONNECTION_PROVIDER;
        }
        if (component instanceof SourceModel) {
            return SOURCE;
        }
        if (component instanceof FunctionModel) {
            return FUNCTION;
        }
        if (component instanceof ConstructModel) {
            return CONSTRUCT;
        }
        if (component instanceof SourceCallbackModel) {
            return SOURCE_CALLBACK;
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not an instance of any known model type [%s, %s, %s, %s, %s]", component.toString(), CONFIGURATION, CONNECTION_PROVIDER, OPERATION, SOURCE, SOURCE_CALLBACK));
    }

    public static String getDeclarationTypeName(ParameterizedDeclaration declaration) {
        if (declaration instanceof OperationDeclaration) {
            return OPERATION;
        }
        if (declaration instanceof ConfigurationDeclaration) {
            return CONFIGURATION;
        }
        if (declaration instanceof ConnectionProviderDeclaration) {
            return CONNECTION_PROVIDER;
        }
        if (declaration instanceof SourceDeclaration) {
            return SOURCE;
        }
        if (declaration instanceof FunctionDeclaration) {
            return FUNCTION;
        }
        if (declaration instanceof ConstructDeclaration) {
            return CONSTRUCT;
        }
        if (declaration instanceof SourceCallbackDeclaration) {
            return SOURCE_CALLBACK;
        }
        throw new IllegalArgumentException(String.format("Declaration '%s' is not an instance of any known model type [%s, %s, %s, %s, %s]", declaration.toString(), CONFIGURATION, CONNECTION_PROVIDER, OPERATION, SOURCE, SOURCE_CALLBACK));
    }

    public static String getComponentDeclarationTypeName(BaseDeclaration declaration) {
        if (declaration instanceof OperationDeclaration) {
            return OPERATION;
        }
        if (declaration instanceof ConfigurationDeclaration) {
            return CONFIGURATION;
        }
        if (declaration instanceof ConnectionProviderDeclaration) {
            return CONNECTION_PROVIDER;
        }
        if (declaration instanceof SourceDeclaration) {
            return SOURCE;
        }
        if (declaration instanceof ConstructDeclaration) {
            return CONSTRUCT;
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not an instance of any known model type [%s, %s, %s, %s]", declaration.toString(), CONFIGURATION, CONNECTION_PROVIDER, OPERATION, SOURCE, CONSTRUCT));
    }

    public static String getModelName(Object model) {
        if (model instanceof NamedObject) {
            return ((NamedObject)model).getName();
        }
        throw new IllegalArgumentException(String.format("Model '%s' is not a named type", new Object[0]));
    }

    public static <T extends NamedObject> List<T> alphaSortDescribedList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        Collections.sort(list, Comparator.comparing(NamedObject::getName));
        return list;
    }

    public static String sanitizeName(String originalName) {
        return originalName.replaceAll("[^\\w|\\.\\-]", "");
    }

    public static String sanitizeName(Optional<String> originalName) {
        return originalName.map(name -> NameUtils.sanitizeName(name)).orElse("");
    }

    static {
        NameUtils.plural("$", "s");
        NameUtils.plural("s$", "s");
        NameUtils.plural("(ax|test)is$", "$1es");
        NameUtils.plural("(octop|vir)us$", "$1i");
        NameUtils.plural("(alias|status)$", "$1es");
        NameUtils.plural("(bu)s$", "$1ses");
        NameUtils.plural("(buffal|tomat)o$", "$1oes");
        NameUtils.plural("([ti])um$", "$1a");
        NameUtils.plural("sis$", "ses");
        NameUtils.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        NameUtils.plural("(hive)$", "$1s");
        NameUtils.plural("([^aeiouy]|qu)y$", "$1ies");
        NameUtils.plural("(x|ch|ss|sh)$", "$1es");
        NameUtils.plural("(matr|vert|ind)ix|ex$", "$1ices");
        NameUtils.plural("([m|l])ouse$", "$1ice");
        NameUtils.plural("^(ox)$", "$1en");
        NameUtils.plural("(quiz)$", "$1zes");
        NameUtils.singular("s$", "");
        NameUtils.singular("(n)ews$", "$1ews");
        NameUtils.singular("([ti])a$", "$1um");
        NameUtils.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        NameUtils.singular("(^analy)ses$", "$1sis");
        NameUtils.singular("([^f])ves$", "$1fe");
        NameUtils.singular("(hive)s$", "$1");
        NameUtils.singular("(tive)s$", "$1");
        NameUtils.singular("([lr])ves$", "$1f");
        NameUtils.singular("([^aeiouy]|qu)ies$", "$1y");
        NameUtils.singular("(s)eries$", "$1eries");
        NameUtils.singular("(m)ovies$", "$1ovie");
        NameUtils.singular("(x|ch|ss|sh)es$", "$1");
        NameUtils.singular("([m|l])ice$", "$1ouse");
        NameUtils.singular("(bus)es$", "$1");
        NameUtils.singular("(o)es$", "$1");
        NameUtils.singular("(shoe)s$", "$1");
        NameUtils.singular("(cris|ax|test)es$", "$1is");
        NameUtils.singular("(octop|vir)i$", "$1us");
        NameUtils.singular("(alias|status)es$", "$1");
        NameUtils.singular("^(ox)en", "$1");
        NameUtils.singular("(vert|ind)ices$", "$1ex");
        NameUtils.singular("(matr)ices$", "$1ix");
        NameUtils.singular("(quiz)zes$", "$1");
        NameUtils.irregular("person", "people");
        NameUtils.irregular("man", "men");
        NameUtils.irregular("child", "children");
        NameUtils.irregular("sex", "sexes");
        NameUtils.irregular("move", "moves");
        NameUtils.uncountable("equipment");
        NameUtils.uncountable("information");
        NameUtils.uncountable("rice");
        NameUtils.uncountable("money");
        NameUtils.uncountable("species");
        NameUtils.uncountable("series");
        NameUtils.uncountable("fish");
        NameUtils.uncountable("sheep");
    }

    private static class Inflection {
        private String pattern;
        private String replacement;
        private boolean ignoreCase;

        public Inflection(String pattern, String replacement) {
            this(pattern, replacement, true);
        }

        public Inflection(String pattern, String replacement, boolean ignoreCase) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.ignoreCase = ignoreCase;
        }

        public boolean match(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).find();
        }

        public String replace(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).replaceAll(this.replacement);
        }
    }
}

