/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.metadata.DefaultMetadataKey;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;

public class MetadataKeyTypeAdapter
extends TypeAdapter<MetadataKey> {
    private Gson gson = new GsonBuilder().create();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(JsonWriter out, MetadataKey value) throws IOException {
        if (value != null) {
            if (value instanceof NullMetadataKey) {
                this.gson.toJson((Object)value, NullMetadataKey.class, out);
                return;
            } else {
                if (!(value instanceof DefaultMetadataKey)) throw new RuntimeException("Couldn't serialize MetadataKey for implementation: " + value.getClass());
                this.gson.toJson((Object)value, DefaultMetadataKey.class, out);
            }
            return;
        } else {
            out.nullValue();
        }
    }

    public MetadataKey read(JsonReader in) throws IOException {
        JsonElement jsonElement = new JsonParser().parse(in);
        return this.toMetadataKey(jsonElement);
    }

    private MetadataKey toMetadataKey(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject metadataKey = jsonElement.getAsJsonObject();
        if (metadataKey.entrySet().isEmpty()) {
            return new NullMetadataKey();
        }
        JsonElement id = metadataKey.get("id");
        JsonElement displayName = metadataKey.get("displayName");
        JsonElement partName = metadataKey.get("partName");
        JsonElement childs = metadataKey.get("childs");
        if (id != null && displayName != null && partName != null && childs != null) {
            MetadataKeyBuilder key = MetadataKeyBuilder.newKey((String)id.getAsString()).withDisplayName(displayName.getAsString()).withPartName(partName.getAsString());
            childs.getAsJsonArray().forEach(child -> key.withChild(this.toMetadataKey((JsonElement)child)));
            return key.build();
        }
        return null;
    }
}

