/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.ComponentMetadataTypesDescriptorResult;

public class ComponentMetadataTypesDescriptorResultTypeAdapter
extends TypeAdapter<ComponentMetadataTypesDescriptorResult> {
    private static final String INPUT_METADATA = "inputMetadata";
    private static final String OUTPUT_METADATA = "outputMetadata";
    private static final String OUTPUT_ATTRIBUTES_METADATA = "outputAttributesMetadata";
    private static final String FAILURES = "failures";
    private final Gson gson;

    public ComponentMetadataTypesDescriptorResultTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, ComponentMetadataTypesDescriptorResult result) throws IOException {
        out.beginObject();
        out.name(FAILURES);
        out.beginArray();
        result.getFailures().stream().forEach(f -> this.gson.toJson(f, new TypeToken<MetadataFailure>(){}.getType(), out));
        out.endArray();
        out.name(INPUT_METADATA);
        if (result.getInputMetadata() != null && !result.getInputMetadata().isEmpty()) {
            out.beginObject();
            for (Map.Entry<String, MetadataType> entry : result.getInputMetadata().entrySet()) {
                out.name(entry.getKey());
                this.gson.toJson((Object)entry.getValue(), new TypeToken<MetadataType>(){}.getType(), out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
        out.name(OUTPUT_METADATA);
        if (result.getOutputMetadata() != null) {
            this.gson.toJson((Object)result.getOutputMetadata(), new TypeToken<MetadataType>(){}.getType(), out);
        } else {
            out.nullValue();
        }
        out.name(OUTPUT_ATTRIBUTES_METADATA);
        if (result.getOutputAttributesMetadata() != null) {
            this.gson.toJson((Object)result.getOutputAttributesMetadata(), new TypeToken<MetadataType>(){}.getType(), out);
        } else {
            out.nullValue();
        }
        out.endObject();
    }

    public ComponentMetadataTypesDescriptorResult read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        JsonArray failuresArray = json.get(FAILURES).getAsJsonArray();
        LinkedList failures = new LinkedList();
        failuresArray.forEach(f -> failures.add(this.gson.fromJson(f, new TypeToken<MetadataFailure>(){}.getType())));
        if (!failures.isEmpty()) {
            return new ComponentMetadataTypesDescriptorResult((MetadataResult<ComponentMetadataTypesDescriptor>)MetadataResult.failure(failures));
        }
        HashMap inputMetadata = new HashMap();
        if (json.has(INPUT_METADATA)) {
            JsonObject inputMapAsJsonObject = json.get(INPUT_METADATA).getAsJsonObject();
            inputMapAsJsonObject.entrySet().stream().forEach(entry -> {
                MetadataType cfr_ignored_0 = (MetadataType)inputMetadata.put(entry.getKey(), this.gson.fromJson((JsonElement)entry.getValue(), new TypeToken<MetadataType>(){}.getType()));
            });
        }
        MetadataType outputMetadata = null;
        if (json.has(OUTPUT_METADATA)) {
            outputMetadata = (MetadataType)this.gson.fromJson((JsonElement)json.get(OUTPUT_METADATA).getAsJsonObject(), new TypeToken<MetadataType>(){}.getType());
        }
        MetadataType outputAttributesMetadata = null;
        if (json.has(OUTPUT_ATTRIBUTES_METADATA)) {
            outputAttributesMetadata = (MetadataType)this.gson.fromJson((JsonElement)json.get(OUTPUT_ATTRIBUTES_METADATA).getAsJsonObject(), new TypeToken<MetadataType>(){}.getType());
        }
        return new ComponentMetadataTypesDescriptorResult((MetadataResult<ComponentMetadataTypesDescriptor>)MetadataResult.success((Object)new ComponentMetadataTypesDescriptor(inputMetadata, outputMetadata, outputAttributesMetadata)));
    }
}

