/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.mule.apache.xml.serialize.OutputFormat;
import org.mule.apache.xml.serialize.XMLSerializer;

public class GenericXmlSerializer<T> {
    private Class<T> serializedType;

    public GenericXmlSerializer(Class<T> serializedType) {
        this.serializedType = serializedType;
    }

    public String serialize(T dto) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.serializedType});
            Marshaller marshaller = jaxbContext.createMarshaller();
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            marshaller.marshal(dto, this.getXmlSerializer(out).asContentHandler());
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(String xml) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.serializedType});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (T)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLSerializer getXmlSerializer(OutputStream out) {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }
}

