/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisistor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedChainModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.internal.persistence.KindEnrichedTypeAdapter;

public class NestedElementModelTypeAdapter
extends KindEnrichedTypeAdapter<NestableElementModel> {
    private static final String COMPONENT_KIND = "component";
    private static final String CHAIN_KIND = "chain";
    private static final String ROUTE_KIND = "route";

    public NestedElementModelTypeAdapter(TypeAdapterFactory typeAdapterFactory, Gson gson) {
        super(typeAdapterFactory, gson);
    }

    @Override
    protected String getKind(NestableElementModel value) {
        final Reference kind = new Reference();
        value.accept(new NestableElementModelVisistor(){

            public void visit(NestedComponentModel component) {
                kind.set((Object)NestedElementModelTypeAdapter.COMPONENT_KIND);
            }

            public void visit(NestedChainModel component) {
                kind.set((Object)NestedElementModelTypeAdapter.CHAIN_KIND);
            }

            public void visit(NestedRouteModel component) {
                kind.set((Object)NestedElementModelTypeAdapter.ROUTE_KIND);
            }
        });
        return (String)kind.get();
    }

    @Override
    protected TypeAdapter<NestableElementModel> getDelegateAdapter(String kind) {
        Class<ImmutableNestedRouteModel> clazz;
        switch (kind) {
            case "route": {
                clazz = ImmutableNestedRouteModel.class;
                break;
            }
            case "chain": {
                clazz = ImmutableNestedChainModel.class;
                break;
            }
            case "component": {
                clazz = ImmutableNestedComponentModel.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown kind [%s] for a NestedElementModel", kind));
            }
        }
        return this.gson.getDelegateAdapter(this.typeAdapterFactory, TypeToken.get(clazz));
    }
}

