/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.grammar;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.extension.internal.operator.EqualsOperator;
import org.mule.runtime.extension.internal.operator.GreaterOperator;
import org.mule.runtime.extension.internal.operator.GreaterOrEqualsOperator;
import org.mule.runtime.extension.internal.operator.LessOperator;
import org.mule.runtime.extension.internal.operator.LessOrEqualsOperator;
import org.mule.runtime.extension.internal.operator.LikeOperator;
import org.mule.runtime.extension.internal.operator.NotEqualsOperator;
import org.mule.runtime.extension.internal.operator.Operator;

final class QueryModelOperatorFactory {
    private static QueryModelOperatorFactory INSTANCE = new QueryModelOperatorFactory();
    private Map<String, Operator> operators = new HashMap<String, Operator>();

    private QueryModelOperatorFactory() {
        this.operators.put("=", new EqualsOperator());
        this.operators.put(">", new GreaterOperator());
        this.operators.put("<", new LessOperator());
        this.operators.put(">=", new GreaterOrEqualsOperator());
        this.operators.put("<=", new LessOrEqualsOperator());
        this.operators.put("<>", new NotEqualsOperator());
        this.operators.put("like", new LikeOperator());
    }

    public static QueryModelOperatorFactory getInstance() {
        return INSTANCE;
    }

    Operator getOperator(String symbol) {
        return this.operators.get(symbol.toLowerCase().trim());
    }
}

