/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.internal.ConfigurationASTElement;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.sdk.api.annotation.Extension;

public class ExtensionTypeElement
extends ConfigurationASTElement
implements ExtensionElement {
    private LazyValue<AnnotationReader> extensionAnnotation = new LazyValue(() -> new AnnotationReader());

    public ExtensionTypeElement(TypeElement typeElement, ProcessingEnvironment processingEnv) {
        super(typeElement, processingEnv);
    }

    public List<ConfigurationElement> getConfigurations() {
        return Stream.concat(this.fetchConfigurationElements(Configurations.class, Configurations::value), this.fetchConfigurationElements(org.mule.sdk.api.annotation.Configurations.class, org.mule.sdk.api.annotation.Configurations::value)).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<ConfigurationElement> fetchConfigurationElements(Class<T> annotationClass, Function<T, Class[]> mapper) {
        return this.getValueFromAnnotation(annotationClass).map(valFetcher -> valFetcher.getClassArrayValue(mapper).stream().map(configType -> new ConfigurationASTElement((TypeElement)configType.getElement().get(), this.processingEnvironment))).orElse(Stream.empty());
    }

    public List<FunctionElement> getFunctions() {
        return this.getFunctionContainerStream().map(rec$ -> ((FunctionContainerElement)rec$).getFunctions()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<OperationElement> getOperations() {
        return this.getOperationElementStream().map(rec$ -> ((OperationContainerElement)rec$).getOperations()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Category getCategory() {
        return ((AnnotationReader)this.extensionAnnotation.get()).getCategory();
    }

    public String getVendor() {
        return ((AnnotationReader)this.extensionAnnotation.get()).getVendor();
    }

    @Override
    public String getName() {
        return ((AnnotationReader)this.extensionAnnotation.get()).getName();
    }

    private class AnnotationReader {
        private final Either<AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.Extension>, AnnotationValueFetcher<Extension>> either;

        private AnnotationReader() {
            Optional<AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.Extension>> left = ExtensionTypeElement.this.getValueFromAnnotation(org.mule.runtime.extension.api.annotation.Extension.class);
            if (left.isPresent()) {
                this.either = Either.left(left.get());
            } else {
                Optional<AnnotationValueFetcher<Extension>> right = ExtensionTypeElement.this.getValueFromAnnotation(Extension.class);
                if (right.isPresent()) {
                    this.either = Either.right(right.get());
                } else {
                    throw new IllegalModelDefinitionException(String.format("Extension is not annotated with neither '%s' nor '%s'", org.mule.runtime.extension.api.annotation.Extension.class.getName(), Extension.class.getName()));
                }
            }
        }

        private String getName() {
            return (String)this.either.reduce(v -> v.getStringValue(org.mule.runtime.extension.api.annotation.Extension::name), v -> v.getStringValue(Extension::name));
        }

        private String getVendor() {
            return (String)this.either.reduce(v -> v.getStringValue(org.mule.runtime.extension.api.annotation.Extension::vendor), v -> v.getStringValue(Extension::vendor));
        }

        private Category getCategory() {
            return (Category)this.either.reduce(v -> (Category)v.getEnumValue(org.mule.runtime.extension.api.annotation.Extension::category), v -> JavaParserUtils.toMuleApi((org.mule.sdk.api.meta.Category)((org.mule.sdk.api.meta.Category)v.getEnumValue(Extension::category))));
        }
    }
}

