/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.lang.reflect.InvocationTargetException;

public class EmbeddedManifest {
    private final Class<?> manifestClass;
    private final Object manifest;

    static EmbeddedManifest getMuleManifest(ClassLoader containerModulesClassLoader) throws ClassNotFoundException {
        try {
            Class<?> manifestClass = containerModulesClassLoader.loadClass("org.mule.runtime.manifest.api.MuleManifest");
            return new EmbeddedManifest(manifestClass, manifestClass.getMethod("getMuleManifest", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException e) {
            return new EmbeddedManifest(containerModulesClassLoader.loadClass("org.mule.runtime.core.api.config.MuleManifest"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    EmbeddedManifest(Class<?> manifestClass) {
        this(manifestClass, null);
    }

    EmbeddedManifest(Class<?> manifestClass, Object manifest) {
        this.manifestClass = manifestClass;
        this.manifest = manifest;
    }

    public String getProductVersion() {
        return this.invokeMethod("getProductVersion");
    }

    public String getSupportedJdks() {
        return this.invokeMethod("getSupportedJdks");
    }

    public String getRecommendedJdks() {
        if (this.manifest != null) {
            return this.invokeMethod("getRecommendedJdks");
        }
        return this.invokeMethod("getRecommndedJdks");
    }

    private String invokeMethod(String methodName) {
        try {
            if (this.manifest != null) {
                return (String)this.manifestClass.getDeclaredMethod(methodName, new Class[0]).invoke(this.manifest, new Object[0]);
            }
            return (String)this.manifestClass.getDeclaredMethod(methodName, new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

