/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.legacy;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.internal.AbstractEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.legacy.Serializer;

public class LegacyEmbeddedContainer
extends AbstractEmbeddedContainer<Object> {
    public LegacyEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration, ClassLoader containerModulesClassLoader, List<URL> services, URL containerBaseFolder, MavenClient mavenClient) {
        super(muleVersion, containerConfiguration, containerModulesClassLoader, services, containerBaseFolder, mavenClient);
    }

    @Override
    protected Object getEmbeddedController(ClassLoader embeddedControllerBootstrapClassLoader, ContainerInfo containerInfo) throws Exception {
        Class<?> controllerClass = embeddedControllerBootstrapClassLoader.loadClass("org.mule.runtime.module.embedded.impl.EmbeddedController");
        Constructor<?> constructor = controllerClass.getConstructor(byte[].class);
        ByteArrayOutputStream containerOutputStream = new ByteArrayOutputStream(512);
        Serializer.serialize(containerInfo, (OutputStream)containerOutputStream);
        return constructor.newInstance(new Object[]{containerOutputStream.toByteArray()});
    }

    @Override
    protected void startEmbeddedController(Object embeddedController) {
        this.executeUsingExecutorService(() -> {
            this.executeUsingReflection(embeddedController, () -> embeddedController.getClass().getMethod("start", new Class[0]), Collections.emptyList());
            return null;
        });
    }

    @Override
    protected void stopEmbeddedController(Object embeddedController) {
        this.executeUsingExecutorService(() -> {
            this.executeUsingReflection(embeddedController, () -> embeddedController.getClass().getMethod("stop", new Class[0]), Collections.emptyList());
            return null;
        });
    }

    @Override
    public DeploymentService doGetDeploymentService(final Object embeddedController) {
        return new DeploymentService(){

            @Override
            public void deployApplication(ArtifactConfiguration artifactConfiguration) {
                LegacyEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    LegacyEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> LegacyEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "deployApplication"), Collections.singletonList(artifactConfiguration));
                    return null;
                });
            }

            @Override
            public void undeployApplication(String applicationName) {
                LegacyEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    LegacyEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> LegacyEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "undeployApplication"), Collections.singletonList(applicationName));
                    return null;
                });
            }

            @Override
            public void deployDomain(ArtifactConfiguration artifactConfiguration) {
                LegacyEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    LegacyEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> LegacyEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "deployDomain"), Collections.singletonList(artifactConfiguration));
                    return null;
                });
            }

            @Override
            public void undeployDomain(String domainName) {
                LegacyEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    LegacyEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> LegacyEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "undeployDomain"), Collections.singletonList(domainName));
                    return null;
                });
            }
        };
    }

    private Method findEmbeddedMethod(Object embeddedController, String methodName) {
        Method[] methods;
        for (Method method : methods = embeddedController.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new RuntimeException(new NoSuchMethodException("Method " + methodName + " not found"));
    }

    private void executeUsingReflection(Object embeddedController, UncheckedSupplier<Method> methodSupplier, List<Serializable> args) throws Exception {
        try {
            Method method = methodSupplier.get();
            List<Object> arguments = args.stream().map(arg -> {
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                Serializer.serialize(arg, (OutputStream)byteOutputStream);
                return byteOutputStream.toByteArray();
            }).collect(Collectors.toList());
            method.invoke(embeddedController, arguments.toArray(new Object[arguments.size()]));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    static interface UncheckedSupplier<T> {
        public T get() throws Exception;
    }
}

