/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.internal.DefaultEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.MavenContainerOptSeparateClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.ReflectionEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.RuntimeProduct;
import org.mule.runtime.module.embedded.internal.legacy.LegacyDefaultEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.legacy.LegacyEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.utils.Preconditions;

public class DefaultEmbeddedContainerBuilder
implements EmbeddedContainer.EmbeddedContainerBuilder {
    private String muleVersion;
    private URI log4jConfigurationFile;
    private MavenConfiguration mavenConfiguration;
    private ContainerConfiguration containerConfiguration;
    private Product product;
    private boolean isolate = true;

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder muleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder product(Product product) {
        this.product = product;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder containerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder log4jConfigurationFile(URI log4JConfigurationFile) {
        this.log4jConfigurationFile = log4JConfigurationFile;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder mavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder useIsolation(boolean isolate) {
        this.isolate = isolate;
        return this;
    }

    @Override
    public EmbeddedContainer build() {
        Preconditions.checkState(this.muleVersion != null, "muleVersion cannot be null");
        Preconditions.checkState(this.mavenConfiguration != null, "mavenConfiguration cannot be null");
        Preconditions.checkState(this.containerConfiguration != null, "containerConfiguration cannot be null");
        Preconditions.checkState(this.log4jConfigurationFile != null, "log4jConfigurationFile cannot be null");
        Preconditions.checkState(this.product != null, "product cannot be null");
        JpmsUtils.validateNoBootModuleLayerTweaking();
        try {
            URL containerBaseFolder = this.containerConfiguration.getContainerFolder().toURI().toURL();
            if (this.log4jConfigurationFile != null) {
                File confDir = new File(org.codehaus.plexus.util.FileUtils.toFile((URL)containerBaseFolder), "conf");
                confDir.mkdirs();
                try (InputStream log4jConfFileInputStream = this.log4jConfigurationFile.toURL().openStream();){
                    FileUtils.copyInputStreamToFile((InputStream)log4jConfFileInputStream, (File)new File(confDir, "log4j2.xml"));
                }
            }
            RuntimeProduct runtimeProduct = new RuntimeProduct(this.product, this.muleVersion);
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)this.getClass().getClassLoader());
            MavenClient mavenClient = mavenClientProvider.createMavenClient(this.mavenConfiguration);
            this.persistMavenConfiguration(containerBaseFolder, this.mavenConfiguration);
            MavenContainerClassLoaderFactory classLoaderFactory = runtimeProduct.isSupportsNewImplementation() ? new MavenContainerOptSeparateClassLoaderFactory(mavenClient, this.isolate) : new MavenContainerClassLoaderFactory(mavenClient);
            try {
                ClassLoader containerModulesClassLoader = classLoaderFactory.create(runtimeProduct, containerBaseFolder.toURI().toURL());
                return this.getEmbeddedContainer(runtimeProduct, containerBaseFolder, mavenClient, classLoaderFactory, containerModulesClassLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create embedded container", e);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private EmbeddedContainer getEmbeddedContainer(RuntimeProduct runtimeProduct, URL containerBaseFolder, MavenClient mavenClient, MavenContainerClassLoaderFactory classLoaderFactory, ClassLoader containerModulesClassLoader) {
        if (runtimeProduct.isSupportsNewImplementation()) {
            if (runtimeProduct.isSupportsIsolation()) {
                return new ReflectionEmbeddedContainer(this.muleVersion, this.containerConfiguration, containerModulesClassLoader, classLoaderFactory.getServices(runtimeProduct), containerBaseFolder, mavenClient);
            }
            if (runtimeProduct.isSupportsControllerApi()) {
                return new DefaultEmbeddedContainer(this.muleVersion, this.containerConfiguration, containerModulesClassLoader, classLoaderFactory.getServices(runtimeProduct), containerBaseFolder, mavenClient);
            }
            return new LegacyDefaultEmbeddedContainer(this.muleVersion, this.containerConfiguration, containerModulesClassLoader, classLoaderFactory.getServices(runtimeProduct), containerBaseFolder, mavenClient);
        }
        return new LegacyEmbeddedContainer(this.muleVersion, this.containerConfiguration, containerModulesClassLoader, classLoaderFactory.getServices(runtimeProduct), containerBaseFolder, mavenClient);
    }

    private void persistMavenConfiguration(URL containerBaseFolder, MavenConfiguration mavenConfiguration) throws IOException {
        File configurationFolder = new File(org.codehaus.plexus.util.FileUtils.toFile((URL)containerBaseFolder), "conf");
        if (!configurationFolder.exists() && !configurationFolder.mkdirs()) {
            throw new IllegalArgumentException("Could not create MULE_HOME/conf folder in: " + configurationFolder.getAbsolutePath());
        }
        JsonObject rootObject = new JsonObject();
        JsonObject muleRuntimeConfigObject = new JsonObject();
        rootObject.add("muleRuntimeConfig", (JsonElement)muleRuntimeConfigObject);
        JsonObject mavenObject = new JsonObject();
        muleRuntimeConfigObject.add("maven", (JsonElement)mavenObject);
        if (!mavenConfiguration.getMavenRemoteRepositories().isEmpty()) {
            JsonObject repositoriesObject = new JsonObject();
            mavenObject.add("repositories", (JsonElement)repositoriesObject);
            mavenConfiguration.getMavenRemoteRepositories().forEach(mavenRepo -> {
                JsonObject repoObject = new JsonObject();
                repositoriesObject.add(mavenRepo.getId(), (JsonElement)repoObject);
                repoObject.addProperty("url", mavenRepo.getUrl().toString());
                mavenRepo.getAuthentication().ifPresent(authentication -> {
                    repoObject.addProperty("username", authentication.getUsername());
                    repoObject.addProperty("password", authentication.getPassword());
                });
                mavenRepo.getSnapshotPolicy().ifPresent(snapshotPolicy -> {
                    JsonObject snapshotPolicyObject = new JsonObject();
                    snapshotPolicyObject.addProperty("enabled", Boolean.valueOf(snapshotPolicy.isEnabled()));
                    snapshotPolicyObject.addProperty("updatePolicy", snapshotPolicy.getUpdatePolicy());
                    snapshotPolicyObject.addProperty("checksumPolicy", snapshotPolicy.getChecksumPolicy());
                    repoObject.add("snapshotPolicy", (JsonElement)snapshotPolicyObject);
                });
                mavenRepo.getReleasePolicy().ifPresent(releasePolicy -> {
                    JsonObject releasePolicyObject = new JsonObject();
                    releasePolicyObject.addProperty("enabled", Boolean.valueOf(releasePolicy.isEnabled()));
                    releasePolicyObject.addProperty("updatePolicy", releasePolicy.getUpdatePolicy());
                    releasePolicyObject.addProperty("checksumPolicy", releasePolicy.getChecksumPolicy());
                    repoObject.add("releasePolicy", (JsonElement)releasePolicyObject);
                });
            });
        }
        mavenObject.addProperty("repositoryLocation", mavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath());
        mavenConfiguration.getUserSettingsLocation().ifPresent(userSettingsLocation -> mavenObject.addProperty("userSettingsLocation", userSettingsLocation.getAbsolutePath()));
        mavenConfiguration.getGlobalSettingsLocation().ifPresent(globalSettingsLocation -> mavenObject.addProperty("globalSettingsLocation", globalSettingsLocation.getAbsolutePath()));
        mavenObject.addProperty("ignoreArtifactDescriptorRepositories", Boolean.valueOf(mavenConfiguration.getIgnoreArtifactDescriptorRepositories()));
        mavenConfiguration.getSettingsSecurityLocation().ifPresent(securitySettingsLocation -> mavenObject.addProperty("settingsSecurityLocation", securitySettingsLocation.getAbsolutePath()));
        mavenObject.addProperty("forcePolicyUpdateNever", Boolean.valueOf(mavenConfiguration.getForcePolicyUpdateNever()));
        mavenObject.addProperty("forcePolicyUpdateAlways", Boolean.valueOf(mavenConfiguration.getForcePolicyUpdateAlways()));
        mavenConfiguration.getActiveProfiles().ifPresent(activeProfiles -> {
            JsonArray activeProfilesArray = new JsonArray();
            activeProfiles.forEach(arg_0 -> ((JsonArray)activeProfilesArray).add(arg_0));
            mavenObject.add("activeProfiles", (JsonElement)activeProfilesArray);
        });
        mavenConfiguration.getInactiveProfiles().ifPresent(inactiveProfiles -> {
            JsonArray inactiveProfilesArray = new JsonArray();
            inactiveProfiles.forEach(arg_0 -> ((JsonArray)inactiveProfilesArray).add(arg_0));
            mavenObject.add("inactiveProfiles", (JsonElement)inactiveProfilesArray);
        });
        mavenObject.addProperty("offLineMode", Boolean.valueOf(mavenConfiguration.getOfflineMode()));
        mavenConfiguration.getUserProperties().ifPresent(userProperties -> {
            JsonObject userPropertiesObject = new JsonObject();
            mavenObject.add("userProperties", (JsonElement)userPropertiesObject);
            userProperties.entrySet().forEach(userPropertyEntry -> {
                JsonObject userPropertyObject = new JsonObject();
                userPropertiesObject.add(userPropertyEntry.getKey().toString(), (JsonElement)userPropertyObject);
                userPropertyObject.addProperty("value", userPropertyEntry.getValue().toString());
            });
        });
        String muleConfigContent = new Gson().toJson((JsonElement)rootObject);
        org.codehaus.plexus.util.FileUtils.fileWrite((File)new File(configurationFolder, "mule-config.json"), (String)muleConfigContent);
    }
}

