/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.classloading;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.module.embedded.internal.classloading.ClassLoaderFilter;
import org.mule.runtime.module.embedded.internal.classloading.ExportedService;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JreExplorer;

public class JdkOnlyClassLoaderFactory {
    public static final Set<String> BOOT_PACKAGES = ImmutableSet.of((Object)"com.yourkit");

    public static FilteringClassLoader create(ClassLoader parentClassLoader, Set<String> additionalExportedBootPackages) {
        HashSet<String> packages = new HashSet<String>(1024);
        HashSet<String> exportedResources = new HashSet<String>(1024);
        ArrayList<ExportedService> services = new ArrayList<ExportedService>(128);
        JreExplorer.exploreJdk(packages, exportedResources, services);
        ClassLoaderFilter classLoaderFilter = new ClassLoaderFilter(JdkOnlyClassLoaderFactory.getExportedBootPackages(packages, additionalExportedBootPackages), exportedResources);
        return new FilteringClassLoader(parentClassLoader, classLoaderFilter, services);
    }

    public static FilteringClassLoader create(ClassLoader parentClassLoader) {
        return JdkOnlyClassLoaderFactory.create(parentClassLoader, Collections.emptySet());
    }

    private static Set<String> getExportedBootPackages(Set<String> packages, Set<String> additionalExportedBootPackages) {
        return ImmutableSet.builder().addAll(BOOT_PACKAGES).addAll(packages).addAll(additionalExportedBootPackages).build();
    }
}

