/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

import org.mule.runtime.module.embedded.internal.DefaultArtifactConfigurationBuilder;

import java.io.File;
import java.io.Serializable;

/**
 * Configuration of an artifact to be run by the embedded container.
 *
 * @since 1.0
 */
public interface ArtifactConfiguration extends Serializable {

  /**
   * @return the {@link DeploymentConfiguration} of the artifact
   */
  DeploymentConfiguration getDeploymentConfiguration();

  /**
   * @return the location of the artifact to run.
   */
  File getArtifactLocation();

  /**
   * @return a new builder to create an {@link ArtifactConfiguration} instance.
   */
  static ArtifactConfigurationBuilder builder() {
    return new DefaultArtifactConfigurationBuilder();
  }

  /**
   * Builder interface to create instances of {@link ArtifactConfiguration}.
   */
  interface ArtifactConfigurationBuilder {

    /**
     * @param artifactLocation the artifact to run. The location may be a path to a folder with the exploded version of the app or
     *                         a path to the jar version of the app.
     * @return same builder
     */
    ArtifactConfigurationBuilder artifactLocation(File artifactLocation);

    /**
     * @param deploymentConfiguration the specific configuration for running the artifact.
     * @return same builder
     */
    ArtifactConfigurationBuilder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

    /**
     * @return a new instance of {@link ArtifactConfiguration} with the provided configuration.
     */
    ArtifactConfiguration build();

  }

}
