/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;

public class DefaultArtifactConfigurationBuilder
implements ArtifactConfiguration.ArtifactConfigurationBuilder {
    private File applicationLocation;
    private DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().build();

    @Override
    public ArtifactConfiguration.ArtifactConfigurationBuilder withArtifactLocation(File artifactLocation) {
        this.applicationLocation = artifactLocation;
        return this;
    }

    @Override
    public ArtifactConfiguration.ArtifactConfigurationBuilder withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    @Override
    public ArtifactConfiguration build() {
        return new ArtifactConfigurationImpl(this.deploymentConfiguration, this.applicationLocation);
    }

    static class ArtifactConfigurationImpl
    implements ArtifactConfiguration {
        private DeploymentConfiguration deploymentConfiguration;
        private File applicationLocation;

        public ArtifactConfigurationImpl(DeploymentConfiguration deploymentConfiguration, File applicationLocation) {
            Preconditions.checkArgument((deploymentConfiguration != null ? 1 : 0) != 0, (Object)"deploymentConfiguration cannot be null");
            Preconditions.checkArgument((applicationLocation != null ? 1 : 0) != 0, (Object)"applicationLocation cannot be null");
            this.deploymentConfiguration = deploymentConfiguration;
            this.applicationLocation = applicationLocation;
        }

        @Override
        public DeploymentConfiguration getDeploymentConfiguration() {
            return this.deploymentConfiguration;
        }

        @Override
        public File getApplicationLocation() {
            return this.applicationLocation;
        }
    }
}

