/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.ast.internal.error.ErrorTypeRepositoryBuildingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseArtifactAst
implements ArtifactAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseArtifactAst.class);

    @Override
    public Stream<ComponentAst> topLevelComponentsStream() {
        return this.topLevelComponents().stream();
    }

    @Override
    public Spliterator<ComponentAst> topLevelComponentsSpliterator() {
        return this.topLevelComponentsStream().spliterator();
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
        return this.recursiveStream(direction).spliterator();
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator() {
        return this.recursiveSpliterator(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        return this.topLevelComponentsStream().flatMap(cm -> cm.recursiveStream(direction));
    }

    @Override
    public Stream<ComponentAst> recursiveStream() {
        return this.recursiveStream(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Stream<ComponentAst> filteredComponents(Predicate<ComponentAst> predicate) {
        return this.recursiveStream().filter(predicate);
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        LOGGER.debug("Creating errorTypeRepository for Artifact '{}'...", (Object)this);
        DefaultErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(this.dependencies(), errorTypeRepository);
        ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact(this, errorTypeRepository);
        return new CompositeErrorTypeRepository(Arrays.asList(this.getParent().map(ArtifactAst::getErrorTypeRepository).orElse(ErrorTypeRepositoryProvider.getCoreErrorTypeRepo()), errorTypeRepository));
    }
}

