/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.param;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.internal.param.ExpressionAwareParameter;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;

public class ParamTypeResolvingVisitor
extends MetadataTypeVisitor {
    private static final Map<String, Function<String, Number>> fixedNumberMappings = new HashMap<String, Function<String, Number>>();
    private final ExpressionAwareParameter param;
    private final String resolvedRawValue;
    private final AtomicReference<String> expression = new AtomicReference();
    private final AtomicReference<Object> fixedValue = new AtomicReference();

    public static Either<String, Object> resolveParamValue(ExpressionAwareParameter param, ComponentMetadataAst metadata, String resolvedRawValue) {
        ParamTypeResolvingVisitor visitor = new ParamTypeResolvingVisitor(param, resolvedRawValue);
        try {
            param.getModel().getType().accept((MetadataTypeVisitor)visitor);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(I18nMessageFactory.createStaticMessage((String)String.format("Exception resolving param '%s' with value '%s' at '%s:%d:%d' (%s)", param.getModel().getName(), resolvedRawValue, metadata != null ? metadata.getFileName().orElse("") : "", metadata != null ? metadata.getStartLine().orElse(-1) : -1, metadata != null ? metadata.getStartColumn().orElse(-1) : -1, e.toString())), e);
        }
        if (visitor.expression.get() != null) {
            return Either.left((Object)visitor.expression.get());
        }
        if (visitor.fixedValue.get() != null) {
            return Either.right((Object)visitor.fixedValue.get());
        }
        return Either.empty();
    }

    public ParamTypeResolvingVisitor(ExpressionAwareParameter param, String resolvedRawValue) {
        this.param = param;
        this.resolvedRawValue = resolvedRawValue;
    }

    public void visitObjectField(ObjectFieldType objectFieldType) {
        objectFieldType.getValue().accept((MetadataTypeVisitor)this);
    }

    public void visitBoolean(BooleanType booleanType) {
        this.doVisitPrimitive((MetadataType)booleanType, () -> {
            if (!StringUtils.isEmpty((CharSequence)this.resolvedRawValue)) {
                this.fixedValue.set(Boolean.valueOf(this.resolvedRawValue));
            }
        });
    }

    public void visitNumber(NumberType numberType) {
        this.doVisitPrimitive((MetadataType)numberType, () -> {
            if (!StringUtils.isEmpty((CharSequence)this.resolvedRawValue)) {
                this.visitFixedNumber(this.resolvedRawValue, this.fixedValue, numberType);
            }
        });
    }

    public void visitString(StringType stringType) {
        this.doVisitPrimitive((MetadataType)stringType, () -> this.fixedValue.set(this.resolvedRawValue));
    }

    private void doVisitPrimitive(MetadataType metadataType, Runnable onFixedValue) {
        if (this.param.isExpression(this.resolvedRawValue) || MuleAstUtils.hasPropertyPlaceholder(this.resolvedRawValue)) {
            this.defaultVisit(metadataType);
        } else {
            onFixedValue.run();
        }
    }

    protected void defaultVisit(MetadataType metadataType) {
        if ((ExpressionSupport.NOT_SUPPORTED.equals((Object)this.param.getModel().getExpressionSupport()) || this.param.getModel().getType().getAnnotation(LiteralTypeAnnotation.class).isPresent()) && (this.param.getModel().getAllowedStereotypes().isEmpty() || this.resolvedRawValue == null)) {
            this.fixedValue.set(this.resolvedRawValue);
        } else {
            this.defaultVisitFixedValue(this.resolvedRawValue, this.expression, this.fixedValue);
        }
    }

    private void visitFixedNumber(String rawValue, AtomicReference<Object> value, NumberType numberType) {
        value.set(numberType.getAnnotation(ClassInformationAnnotation.class).map(classInfo -> fixedNumberMappings.getOrDefault(classInfo.getClassname(), s -> null).apply(rawValue)).orElseGet(() -> {
            try {
                Long longValue = Long.valueOf(rawValue);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return longValue.intValue();
                }
                return longValue;
            }
            catch (NumberFormatException e) {
                return Double.valueOf(rawValue);
            }
        }));
    }

    private void defaultVisitFixedValue(String rawValue, AtomicReference<String> expression, AtomicReference<Object> fixedValue) {
        Optional<String> expressionOpt = this.param.extractExpression(rawValue);
        if (expressionOpt.isPresent()) {
            expression.set(expressionOpt.get());
        } else {
            fixedValue.set(rawValue);
        }
    }

    static {
        fixedNumberMappings.put(Integer.class.getName(), Integer::valueOf);
        fixedNumberMappings.put(Integer.TYPE.getName(), Integer::valueOf);
        fixedNumberMappings.put(Float.class.getName(), Float::valueOf);
        fixedNumberMappings.put(Float.TYPE.getName(), Float::valueOf);
        fixedNumberMappings.put(Long.class.getName(), Long::valueOf);
        fixedNumberMappings.put(Long.TYPE.getName(), Long::valueOf);
        fixedNumberMappings.put(Byte.class.getName(), Byte::valueOf);
        fixedNumberMappings.put(Byte.TYPE.getName(), Byte::valueOf);
        fixedNumberMappings.put(Short.class.getName(), Short::valueOf);
        fixedNumberMappings.put(Short.TYPE.getName(), Short::valueOf);
        fixedNumberMappings.put(Double.class.getName(), Double::valueOf);
        fixedNumberMappings.put(Double.TYPE.getName(), Double::valueOf);
        fixedNumberMappings.put(BigDecimal.class.getName(), BigDecimal::new);
        fixedNumberMappings.put(BigInteger.class.getName(), BigInteger::new);
    }
}

