/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public interface Validation {
    public String getName();

    public String getDescription();

    public Level getLevel();

    public Predicate<List<ComponentAst>> applicable();

    default public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        return this.validateMany(component, artifact).stream().findFirst();
    }

    default public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return this.validate(component, artifact).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
    }

    public static enum Level {
        ERROR,
        WARN;

    }
}

