/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.List;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class ComponentAstPredicatesFactory {
    private ComponentAstPredicatesFactory() {
    }

    public static Predicate<ComponentAst> equalsIdentifier(ComponentIdentifier identifier) {
        return c -> c.getIdentifier().equals(identifier);
    }

    public static Predicate<ComponentAst> equalsComponentId(String componentId) {
        return c -> c.getComponentId().map(componentId::equals).orElse(false);
    }

    public static Predicate<ComponentAst> equalsNamespace(String namespace) {
        return c -> c.getIdentifier().getNamespace().equals(namespace);
    }

    public static Predicate<ComponentAst> equalsLocation(ComponentLocation location) {
        return c -> location.equals(c.getLocation());
    }

    public static Predicate<List<ComponentAst>> topLevelElement() {
        return c -> c.size() == 1;
    }

    public static Predicate<List<ComponentAst>> currentElemement(Predicate<ComponentAst> currentElementPredicate) {
        return c -> currentElementPredicate.test((ComponentAst)c.get(c.size() - 1));
    }
}

