/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParserFactory;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.internal.builder.ImportedResourceBuilder;
import org.mule.runtime.ast.internal.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.ast.internal.xml.model.AggregatedImportsArtifactAst;
import org.mule.runtime.ast.internal.xml.model.AggregatedMultiConfigsArtifactAst;
import org.mule.runtime.ast.internal.xml.reader.ArtifactRootElement;
import org.mule.runtime.ast.internal.xml.reader.ComponentAstReader;
import org.mule.runtime.ast.internal.xml.resolver.CachingExtensionSchemaGenerator;
import org.mule.runtime.ast.internal.xml.resolver.ModuleDelegatingEntityResolver;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlGrammarPoolManager;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultAstXmlParser
implements AstXmlParser {
    private static final String DEFAULT_ARTIFACT_NAME = "artifact";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAstXmlParser.class);
    private static final SAXParserFactory SAX_PARSER_FACTORY = XMLSecureFactories.createDefault().getSAXParserFactory();
    private static final ComponentAstReader CONFIG_READER = new ComponentAstReader();
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    private final XMLGrammarPool grammarPool;
    private final EntityResolver entityResolver;
    private final XmlApplicationParser xmlApplicationParser;
    private final ArtifactType artifactType;
    private final Set<ExtensionModel> extensionModels;
    private final ArtifactAst parentArtifact;
    private final ExtensionModelHelper extensionModelHelper;
    private final ParsingPropertyResolver propertyResolver;
    private final Map<Document, ArtifactAst> byDocumentCache = new HashMap<Document, ArtifactAst>();
    private final Map<ConfigResource, Pair<Long, ArtifactAst>> byResourceCache = new HashMap<ConfigResource, Pair<Long, ArtifactAst>>();

    public DefaultAstXmlParser(ArtifactType artifactType, Set<ExtensionModel> extensionModels, ArtifactAst parentArtifact, Optional<ExtensionSchemaGenerator> schemaGenerator, ParsingPropertyResolver propertyResolver, ResolveEntityFailStrategy resolveEntityFailStrategy) {
        this.artifactType = artifactType;
        this.extensionModels = Collections.unmodifiableSet(new HashSet<ExtensionModel>(extensionModels));
        this.parentArtifact = parentArtifact;
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(this.extensionModels);
        this.extensionModelHelper = ExtensionModelHelper.defaultExtensionModelHelper(this.extensionModels, (DslResolvingContext)dslResolvingContext);
        this.xmlConfigurationDocumentLoader = schemaGenerator.isPresent() ? XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader() : XmlConfigurationDocumentLoader.noValidationDocumentLoader();
        this.grammarPool = schemaGenerator.isPresent() ? (XMLGrammarPool)DefaultXmlGrammarPoolManager.getGrammarPool().orElse(null) : null;
        this.entityResolver = schemaGenerator.map(sg -> new ModuleDelegatingEntityResolver(extensionModels, new CachingExtensionSchemaGenerator((ExtensionSchemaGenerator)sg), dslResolvingContext, this.extensionModelHelper, resolveEntityFailStrategy)).orElseGet(DefaultHandler::new);
        this.propertyResolver = propertyResolver;
        List<XmlNamespaceInfoProvider> namespaceInfoProviders = XmlNamespaceInfoProviderSupplier.createFromExtensionModels(extensionModels);
        this.xmlApplicationParser = new XmlApplicationParser(namespaceInfoProviders);
    }

    @Override
    public ArtifactAst parseDocument(String artifactName, List<Pair<String, Document>> appXmlConfigDocuments) {
        if (appXmlConfigDocuments.isEmpty()) {
            throw new IllegalArgumentException("At least one 'appXmlConfigInputStream' must be provided");
        }
        LOGGER.debug("About to parse AST from XML Documents {}", appXmlConfigDocuments);
        List<ConfigResource> baseAstResources = appXmlConfigDocuments.stream().map(is -> {
            try {
                return new ConfigResource((String)is.getFirst());
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).collect(Collectors.toList());
        LinkedHashMap<ConfigResource, ArtifactAst> importedConfigs = new LinkedHashMap<ConfigResource, ArtifactAst>();
        baseAstResources.forEach(r -> importedConfigs.put((ConfigResource)r, MuleAstUtils.emptyArtifact()));
        return this.resolveImports(this.aggregateAsts(appXmlConfigDocuments.stream().map(resource -> this.byDocumentCache.computeIfAbsent((Document)resource.getSecond(), document -> this.doParse(artifactName, (Document)document, (String)resource.getFirst(), null, Collections.emptyList(), (List<String>)new ArrayList<String>()))).collect(Collectors.toList())), importedConfigs);
    }

    @Override
    public ArtifactAst parseDocument(List<Pair<String, Document>> appXmlConfigDocuments) {
        return this.parseDocument(DEFAULT_ARTIFACT_NAME, appXmlConfigDocuments);
    }

    @Override
    public ArtifactAst parse(String artifactName, List<Pair<String, InputStream>> appXmlConfigInputStreams) {
        if (appXmlConfigInputStreams.isEmpty()) {
            throw new IllegalArgumentException("At least one 'appXmlConfigInputStream' must be provided");
        }
        LOGGER.debug("About to parse AST from inputStreams {}", appXmlConfigInputStreams);
        List<ConfigResource> baseAstResources = appXmlConfigInputStreams.stream().map(is -> this.inputStreamToConfigResource((String)is.getFirst(), (InputStream)is.getSecond())).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(resource -> this.doParse(artifactName, (ConfigResource)resource)).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(List<Pair<String, InputStream>> appXmlConfigInputStreams) {
        return this.parse(DEFAULT_ARTIFACT_NAME, appXmlConfigInputStreams);
    }

    @Override
    public ArtifactAst parse(String artifactName, ConfigResource ... appXmlConfigResources) {
        if (appXmlConfigResources.length == 0) {
            throw new IllegalArgumentException("At least one 'appXmlConfigResources' must be provided");
        }
        List<ConfigResource> baseAstResources = Arrays.asList(appXmlConfigResources);
        LOGGER.debug("About to parse AST from config resources {}", baseAstResources);
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(resource -> this.doParse(artifactName, (ConfigResource)resource)).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(ConfigResource ... appXmlConfigResources) {
        return this.parse(DEFAULT_ARTIFACT_NAME, appXmlConfigResources);
    }

    @Override
    public ArtifactAst parse(String artifactName, String resourceName, InputStream appXmlConfigInputStream) {
        LOGGER.debug("About to parse AST from inputStream {}, {}", (Object)resourceName, (Object)appXmlConfigInputStream);
        ConfigResource baseAstResource = this.inputStreamToConfigResource(resourceName, appXmlConfigInputStream);
        return this.resolveImports(this.doParse(artifactName, baseAstResource), Collections.singletonList(baseAstResource));
    }

    @Override
    public ArtifactAst parse(String resourceName, InputStream appXmlConfigInputStream) {
        return this.parse(DEFAULT_ARTIFACT_NAME, resourceName, appXmlConfigInputStream);
    }

    @Override
    public ArtifactAst parse(String artifactName, URI ... appXmlConfigUris) {
        if (appXmlConfigUris.length == 0) {
            throw new IllegalArgumentException("At least one 'appXmlConfigUri' must be provided");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to parse AST from uris {}", Arrays.asList(appXmlConfigUris));
        }
        List<ConfigResource> baseAstResources = Stream.of(appXmlConfigUris).map(this::uriToConfigResource).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(resource -> this.doParse(artifactName, (ConfigResource)resource)).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(URI ... appXmlConfigUris) {
        return this.parse(DEFAULT_ARTIFACT_NAME, appXmlConfigUris);
    }

    @Override
    public ArtifactAst parse(String artifactName, URL ... appXmlConfigUrls) {
        if (appXmlConfigUrls.length == 0) {
            throw new IllegalArgumentException("At least one 'appXmlConfigUrl' must be provided");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to parse AST from urls {}", Arrays.asList(appXmlConfigUrls));
        }
        List<ConfigResource> baseAstResources = Stream.of(appXmlConfigUrls).map(this::urlToConfigResource).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(resource -> this.doParse(artifactName, (ConfigResource)resource)).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(URL ... appXmlConfigUrls) {
        return this.parse(DEFAULT_ARTIFACT_NAME, appXmlConfigUrls);
    }

    private ArtifactAst aggregateAsts(List<ArtifactAst> parsedAstsList) {
        if (parsedAstsList.size() == 1) {
            return parsedAstsList.get(0);
        }
        return new AggregatedMultiConfigsArtifactAst(this.parentArtifact, parsedAstsList);
    }

    private ArtifactAst resolveImports(ArtifactAst base, List<ConfigResource> baseAstResources) {
        LinkedHashMap<ConfigResource, ArtifactAst> importedConfigs = new LinkedHashMap<ConfigResource, ArtifactAst>();
        baseAstResources.forEach(r -> importedConfigs.put((ConfigResource)r, MuleAstUtils.emptyArtifact()));
        return this.resolveImports(base, importedConfigs);
    }

    protected ArtifactAst resolveImports(ArtifactAst base, Map<ConfigResource, ArtifactAst> importedConfigs) {
        ArrayList<ImportedResource> importedResources = new ArrayList<ImportedResource>();
        this.resolveImports(base, importedConfigs, importedResources, Collections.emptyList());
        if (importedResources.isEmpty()) {
            return base;
        }
        return new AggregatedImportsArtifactAst(this.parentArtifact, importedResources, importedConfigs.values(), base);
    }

    private ArtifactAst doParse(String artifactName, ConfigResource resource) {
        try {
            return this.doParse(artifactName, resource, Collections.emptyList(), new ArrayList<String>());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ArtifactAst doParse(String artifactName, ConfigResource resource, List<ImportedResource> importChain, List<String> warnings) throws IOException {
        Pair<Long, ArtifactAst> cachedResource = this.byResourceCache.get(resource);
        if (cachedResource == null || resource.getLastModified() > (Long)cachedResource.getFirst()) {
            try (InputStream inputStream = resource.getInputStream();){
                Document document = this.xmlConfigurationDocumentLoader.loadDocument(() -> SAX_PARSER_FACTORY, this.entityResolver, resource.getResourceName(), inputStream, this.grammarPool);
                ArtifactAst parsedAst = this.doParse(artifactName, document, resource.getResourceName(), resource.getUrl(), importChain, warnings);
                this.byResourceCache.put(resource, (Pair<Long, ArtifactAst>)new Pair((Object)resource.getLastModified(), (Object)parsedAst));
                ArtifactAst artifactAst = parsedAst;
                return artifactAst;
            }
        }
        return (ArtifactAst)cachedResource.getSecond();
    }

    private ArtifactAst doParse(String artifactName, Document document, String resourceName, URL resourceUrl, List<ImportedResource> importChain, List<String> warnings) {
        ArtifactAstBuilder astBuilder = ArtifactAstBuilder.builder((String)artifactName, (ArtifactType)this.artifactType, this.extensionModels, Optional.ofNullable(this.parentArtifact), arg_0 -> ((ParsingPropertyResolver)this.propertyResolver).resolveProperty(arg_0), (ExtensionModelHelper)this.extensionModelHelper);
        Element rootElement = document.getDocumentElement();
        ArtifactRootElement artifactRootelement = ArtifactRootElement.from(this.xmlApplicationParser, rootElement);
        ArtifactType resolvedRootElement = artifactRootelement.resolveType();
        if (!this.artifactType.equals((Object)resolvedRootElement)) {
            warnings.add(String.format("Imported resource '%s' declares a '%s', not a '%s'", resourceName, resolvedRootElement, this.artifactType));
        }
        if (artifactRootelement.isXmlSdkModule()) {
            CONFIG_READER.processAttributes(astBuilder, rootElement);
            try {
                CONFIG_READER.extractComponentDefinitionModel(this.xmlApplicationParser, rootElement, resourceName, resourceUrl, importChain, () -> ((ArtifactAstBuilder)astBuilder).addTopLevelComponent(), () -> ((ArtifactAstBuilder)astBuilder).createMetadataBuilder());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception extracting definition model for component {}.", (Object[])new Object[]{rootElement.getTagName()}), (Throwable)e);
            }
        } else {
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                CONFIG_READER.processAttributes(astBuilder, (Element)child);
                if (IMPORT_IDENTIFIER.getName().equals(child.getNodeName())) {
                    CONFIG_READER.extractImport(astBuilder, (Element)child, resourceName, resourceUrl, importChain, () -> ((ArtifactAstBuilder)astBuilder).createMetadataBuilder());
                    continue;
                }
                try {
                    CONFIG_READER.extractComponentDefinitionModel(this.xmlApplicationParser, (Element)child, resourceName, resourceUrl, importChain, () -> ((ArtifactAstBuilder)astBuilder).addTopLevelComponent(), () -> ((ArtifactAstBuilder)astBuilder).createMetadataBuilder());
                    continue;
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception extracting definition model for component {}.", (Object[])new Object[]{((Element)child).getTagName()}), (Throwable)e);
                }
            }
        }
        return astBuilder.build();
    }

    private void resolveImports(ArtifactAst parsedConfig, Map<ConfigResource, ArtifactAst> alreadyResolvedConfigFiles, Collection<ImportedResource> importedResources, List<ImportedResource> importChain) {
        parsedConfig.getImportedResources().stream().forEach(importedResource -> {
            ArtifactAst parsedImportedConfig;
            ConfigResource importedConfigResource;
            String importFile;
            try {
                importFile = importedResource.getResourceLocation();
            }
            catch (PropertyNotFoundException pnfe) {
                importedResources.add(ImportedResourceBuilder.builder().withResourceLocation(importedResource.getRawResourceLocation()).withMetadata(importedResource.getMetadata()).withResolutionFailure(String.format("Could not resolve imported resource '%s': %s", importedResource.getRawResourceLocation(), pnfe.getMessage())).build());
                return;
            }
            URL importedResourceUrl = Thread.currentThread().getContextClassLoader().getResource(importFile);
            if (importedResourceUrl == null) {
                importedResources.add(ImportedResourceBuilder.builder().withResourceLocation(importedResource.getResourceLocation()).withMetadata(importedResource.getMetadata()).withResolutionFailure(String.format("Could not find imported resource '%s'", importFile)).build());
                return;
            }
            try {
                importedConfigResource = new ConfigResource(importFile, importedResourceUrl);
            }
            catch (IOException e) {
                importedResources.add((ImportedResource)importedResource);
                return;
            }
            if (alreadyResolvedConfigFiles.containsKey(importedConfigResource)) {
                importedResources.add((ImportedResource)importedResource);
                return;
            }
            LOGGER.debug("Resolving import {}", (Object)importedConfigResource.getResourceName());
            ImmutableList updatedImportChain = ImmutableList.builder().addAll((Iterable)importChain).add(importedResource).build();
            ArrayList<String> warnings = new ArrayList<String>();
            try {
                parsedImportedConfig = this.doParse(parsedConfig.getArtifactName(), importedConfigResource, (List<ImportedResource>)updatedImportChain, warnings);
            }
            catch (Exception e) {
                importedResources.add(ImportedResourceBuilder.builder().withResourceLocation(importedResource.getResourceLocation()).withMetadata(importedResource.getMetadata()).withResolutionFailure(e.getMessage()).build());
                return;
            }
            if (!warnings.isEmpty()) {
                importedResources.add(ImportedResourceBuilder.builder().withResourceLocation(importedResource.getResourceLocation()).withMetadata(importedResource.getMetadata()).withResolutionFailure(warnings.stream().collect(Collectors.joining("; "))).build());
            } else {
                importedResources.add((ImportedResource)importedResource);
            }
            alreadyResolvedConfigFiles.put(importedConfigResource, parsedImportedConfig);
            this.resolveImports(parsedImportedConfig, alreadyResolvedConfigFiles, importedResources, (List<ImportedResource>)updatedImportChain);
        });
    }

    private ConfigResource uriToConfigResource(URI appXmlConfig) {
        URL appXmlConfigUrl;
        try {
            appXmlConfigUrl = appXmlConfig.toURL();
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return this.urlToConfigResource(appXmlConfigUrl);
    }

    private ConfigResource urlToConfigResource(URL appXmlConfigUrl) {
        ConfigResource configResource = new ConfigResource(appXmlConfigUrl);
        try {
            configResource.getInputStream();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return configResource;
    }

    private ConfigResource inputStreamToConfigResource(String resourceName, InputStream appXmlConfigInputStream) {
        return new ConfigResource(resourceName, appXmlConfigInputStream);
    }
}

