/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.xml.resolver.MuleCustomEntityResolver;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDelegatingEntityResolver.class);
    private final Set<ExtensionModel> extensions;
    private final EntityResolver muleEntityResolver;
    private final ExtensionSchemaGenerator extensionSchemaFactory;
    private final DslResolvingContext dslResolvingContext;
    private final ExtensionModelHelper extensionModelHelper;
    private final ResolveEntityFailStrategy failStrategy;

    public ModuleDelegatingEntityResolver(Set<ExtensionModel> extensions, ExtensionSchemaGenerator extensionSchemaFactory, DslResolvingContext dslResolvingContext, ExtensionModelHelper extensionModelHelper, ResolveEntityFailStrategy failStrategy) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.muleEntityResolver = new MuleCustomEntityResolver(classLoader);
        this.extensions = extensions;
        this.extensionSchemaFactory = extensionSchemaFactory;
        this.dslResolvingContext = dslResolvingContext;
        this.extensionModelHelper = extensionModelHelper;
        this.failStrategy = failStrategy;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Looking schema for public identifier(publicId): '%s', system identifier(systemId): '%s'", publicId == null ? "" : publicId, systemId));
        }
        if ((inputSource = this.muleEntityResolver.resolveEntity(publicId, systemId = SchemaMappingsUtils.resolveSystemId((String)systemId))) == null) {
            inputSource = this.generateFromExtensions(publicId, systemId);
        }
        if (inputSource == null) {
            this.failStrategy.execute(publicId, systemId);
        }
        return inputSource;
    }

    private InputSource generateFromExtensions(String publicId, String systemId) {
        return this.extensions.stream().filter(em -> systemId.equals(em.getXmlDslModel().getSchemaLocation())).map(em -> {
            InputStream schema = this.getSchemaFromExtension((ExtensionModel)em);
            InputSource inputSource = new InputSource(schema);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
            return inputSource;
        }).findAny().orElse(null);
    }

    private InputStream getSchemaFromExtension(ExtensionModel extensionModel) {
        return new ByteArrayInputStream(this.extensionSchemaFactory.generate(extensionModel, this.dslResolvingContext, this.extensionModelHelper.getDslSyntaxResolverFor(extensionModel)).getBytes(StandardCharsets.UTF_8));
    }
}

